/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.gadget.core.SecurityTokenGenerator;
import org.exoplatform.portal.webui.util.Util;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetUtil {
    public static Gadget toGadget(String name, String path, boolean isLocal) throws Exception {
        Gadget gadget = new Gadget();
        gadget.setName(name);
        gadget.setUrl(path);
        gadget.setLocal(Boolean.valueOf(isLocal));
        Map<String, String> metaData = GadgetUtil.getMapMetadata(GadgetUtil.reproduceUrl(path, isLocal));
        if (metaData.containsKey("errors")) {
            throw new Exception("error on the server: " + metaData.get("errors"));
        }
        String title = metaData.get("directoryTitle");
        if (title == null || title.trim().length() < 1) {
            title = metaData.get("title");
        }
        if (title == null || title.trim().length() < 1) {
            title = gadget.getName();
        }
        gadget.setTitle(title);
        gadget.setDescription(metaData.get("description"));
        gadget.setReferenceUrl(metaData.get("titleUrl"));
        gadget.setThumbnail(metaData.get("thumbnail"));
        return gadget;
    }

    @Deprecated
    public static String fetchGagdetMetadata(String urlStr) {
        String result = null;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
        try {
            String data = "{\"context\":{\"country\":\"" + gadgetService.getCountry() + "\",\"language\":\"" + gadgetService.getLanguage() + "\"},\"gadgets\":[" + "{\"moduleId\":" + gadgetService.getModuleId() + ",\"url\":\"" + urlStr + "\",\"prefs\":[]}]}";
            String gadgetServer = GadgetUtil.getGadgetServerUrl();
            URL url = new URL(gadgetServer + (gadgetServer.endsWith("/") ? "" : "/") + "metadata");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            result = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            wr.close();
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace();
            return "{}";
        }
        return result;
    }

    public static String fetchGagdetRpcMetadata(String urlStr) {
        String result = null;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
        try {
            String data = "[{method:\"gadgets.metadata\", id:\"test\", params: {ids:[\"" + urlStr + "\"], container:\"default\", language:\"" + gadgetService.getLanguage() + "\", country:\"" + gadgetService.getCountry() + "\", view:\"home\"}}]";
            String gadgetServer = GadgetUtil.getGadgetServerUrl();
            URL url = new URL(gadgetServer + (gadgetServer.endsWith("/") ? "" : "/") + "api/rpc");
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            result = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            wr.close();
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace();
            return "{}";
        }
        return result;
    }

    public static String createToken(String gadgetURL, Long moduleId) {
        SecurityTokenGenerator tokenGenerator = (SecurityTokenGenerator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SecurityTokenGenerator.class);
        return tokenGenerator.createToken(gadgetURL, moduleId);
    }

    public static Map<String, String> getMapMetadata(String url) throws JSONException {
        HashMap<String, String> mapMetaData = new HashMap<String, String>();
        String metadata = GadgetUtil.fetchGagdetRpcMetadata(url);
        metadata = metadata.substring(metadata.indexOf("[") + 1, metadata.lastIndexOf("]"));
        JSONObject jsonObj = new JSONObject(metadata).getJSONObject("result").getJSONObject(url).getJSONObject("modulePrefs");
        Iterator iter = jsonObj.keys();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            mapMetaData.put(element, jsonObj.get(element).toString());
        }
        return mapMetaData;
    }

    public static String reproduceUrl(String path, boolean isLocal) {
        if (isLocal) {
            return GadgetUtil.getViewPath(path);
        }
        return path;
    }

    public static String getViewPath(String uri) {
        return GadgetUtil.getLocalHostBase() + "/" + PortalContainer.getCurrentRestContextName() + "/" + uri;
    }

    public static String getEditPath(String uri) {
        return GadgetUtil.getLocalHostBase() + "/" + PortalContainer.getCurrentRestContextName() + "/private/" + uri;
    }

    public static String getGadgetServerUrl() {
        String uriString = GadgetUtil.getGadgetServerURI();
        try {
            new URL(uriString);
        }
        catch (Exception e) {
            return GadgetUtil.getLocalHostBase() + (uriString.startsWith("/") ? uriString : "/" + uriString);
        }
        return uriString;
    }

    @Deprecated
    public static String getRelGadgetServerUrl() {
        return GadgetUtil.getGadgetServerUrl();
    }

    private static String getGadgetServerURI() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
        return gadgetService.getHostName();
    }

    private static String getLocalHostBase() {
        HttpServletRequest request = Util.getPortalRequestContext().getRequest();
        return request.getScheme() + "://" + request.getServerName() + (request.getServerPort() != 80 ? ":" + request.getServerPort() : "");
    }
}

