/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.impl.core.ExtendedNamespaceRegistry;

public class UpgradeNamespaceWebcontentPlugin
extends UpgradeProductPlugin {
    private RepositoryService repositoryService;
    private ConfigurationManager configurationManager;

    public UpgradeNamespaceWebcontentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService) throws Exception {
        super(initParams);
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            ExtendedNamespaceRegistry namespaceRegistry = (ExtendedNamespaceRegistry)this.repositoryService.getCurrentRepository().getNamespaceRegistry();
            String oldNamespaceURL = namespaceRegistry.getNamespaceURIByPrefix("cia");
            if (oldNamespaceURL.equalsIgnoreCase("http://www.bull.com/fr/aladinng/cia/1.0")) {
                namespaceRegistry.unregisterNamespace("cia");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return newVersion.contains("3.5.5");
    }
}

