/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent.locks;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.cache.util.concurrent.locks.PerElementLockContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerElementReentrantLockContainer<E>
extends PerElementLockContainer<E> {
    public PerElementReentrantLockContainer(int concurrencyLevel) {
        super(concurrencyLevel);
    }

    @Override
    public boolean ownsLock(E object, Object owner) {
        ReentrantLock l = this.getLockFromMap(object);
        return l != null && l.isHeldByCurrentThread();
    }

    @Override
    public boolean isLocked(E object) {
        ReentrantLock l = this.getLockFromMap(object);
        return l != null && l.isLocked();
    }

    private ReentrantLock getLockFromMap(E key) {
        return (ReentrantLock)this.locks.get(key);
    }

    @Override
    protected final Lock newLock() {
        return new ReentrantLock();
    }
}

