/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.preload.ConcurrentPreloads;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.preload.PreloaderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentPreloaderService
implements PreloaderService {
    private final ExecutorService executor;
    private Preloader preloader;

    @Inject
    public ConcurrentPreloaderService(ExecutorService executor, Preloader preloader) {
        this.executor = executor;
        this.preloader = preloader;
    }

    @Override
    public Collection<PreloadedData> preload(Gadget gadget) {
        Collection<Callable<PreloadedData>> tasks = this.preloader.createPreloadTasks(gadget);
        return this.preload(tasks);
    }

    @Override
    public Collection<PreloadedData> preload(Collection<Callable<PreloadedData>> tasks) {
        ConcurrentPreloads preloads = new ConcurrentPreloads(tasks.size());
        int processed = tasks.size();
        for (Callable<PreloadedData> task : tasks) {
            if (--processed == 0) {
                FutureTask<PreloadedData> futureTask = new FutureTask<PreloadedData>(task);
                futureTask.run();
                preloads.add(futureTask);
                continue;
            }
            preloads.add(this.executor.submit(task));
        }
        return preloads;
    }
}

