/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.gadgets.render.DefaultServiceFetcher;
import org.apache.shindig.gadgets.render.RpcServiceLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultRpcServiceLookup
implements RpcServiceLookup {
    private final ConcurrentMap<String, Multimap<String, String>> containerServices;
    private final DefaultServiceFetcher fetcher;

    @Inject
    public DefaultRpcServiceLookup(DefaultServiceFetcher fetcher, @Named(value="org.apache.shindig.serviceExpirationDurationMinutes") Long duration) {
        this.containerServices = new MapMaker().expiration(duration * 60L, TimeUnit.SECONDS).makeMap();
        this.fetcher = fetcher;
    }

    @Override
    public Multimap<String, String> getServicesFor(String container, String host) {
        if (container == null || container.length() == 0 || host == null) {
            return ImmutableMultimap.builder().build();
        }
        Multimap<String, String> foundServices = (Multimap<String, String>)this.containerServices.get(container);
        if (foundServices == null && (foundServices = this.fetcher.getServicesForContainer(container, host)) != null) {
            this.setServicesFor(container, foundServices);
        }
        if (foundServices == null) {
            foundServices = ImmutableMultimap.builder().build();
        }
        return foundServices;
    }

    void setServicesFor(String container, Multimap<String, String> foundServices) {
        this.containerServices.put(container, foundServices);
    }
}

