/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.shindig.auth.BasicSecurityTokenCodec;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.config.ContainerConfig;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ExoSecurityTokenDecoder
implements SecurityTokenCodec {
    private static final String SECURITY_TOKEN_TYPE = "gadgets.securityTokenType";
    private final SecurityTokenCodec decoder;

    @Inject
    public ExoSecurityTokenDecoder(ContainerConfig config) {
        String tokenType = config.getString("default", SECURITY_TOKEN_TYPE);
        if ("insecure".equals(tokenType)) {
            this.decoder = new BasicSecurityTokenCodec();
        } else if ("secure".equals(tokenType)) {
            this.decoder = new ExoBlobCrypterSecurityDecoder(config);
        } else {
            throw new RuntimeException("Unknown security token type specified in default container configuration. gadgets.securityTokenType: " + tokenType);
        }
    }

    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        return this.decoder.createToken(tokenParameters);
    }

    public String encodeToken(SecurityToken token) throws SecurityTokenException {
        throw new RuntimeException();
    }

    public Long getTokenExpiration(SecurityToken token) throws SecurityTokenException {
        throw new RuntimeException();
    }
}

