/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.AbstractLogInterface;
import com.arjuna.common.util.logging.Logi18n;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class AbstractLogImpl
implements Logi18n {
    private AbstractLogInterface m_logInterface = null;
    protected String m_resourceBundleName = "no resource bundle set";
    private ResourceBundle m_defaultResourceBundle = null;
    private ResourceBundle[] m_extraResourceBundles = null;
    private long m_debugLevel = 0L;
    private long m_visLevel = -1L;
    private long m_facLevel = -1L;

    public AbstractLogImpl(AbstractLogInterface logInterface) {
        this.m_logInterface = logInterface;
    }

    public AbstractLogImpl(AbstractLogInterface logInterface, String resBundle) {
        this.m_logInterface = logInterface;
        this.addResourceBundle(resBundle);
    }

    public AbstractLogImpl(AbstractLogInterface logInterface, String[] resBundles) {
        this.m_logInterface = logInterface;
        for (int i = 0; i < resBundles.length; ++i) {
            this.addResourceBundle(resBundles[i]);
        }
    }

    public synchronized void setResourceBundleName(String baseName) {
        try {
            this.m_resourceBundleName = baseName;
            this.m_defaultResourceBundle = PropertyResourceBundle.getBundle(baseName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            System.err.println("resource bundle " + mre.getClassName() + " not found!");
        }
    }

    public synchronized void addResourceBundle(String bundleName) {
        try {
            if (this.m_defaultResourceBundle == null) {
                this.m_defaultResourceBundle = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
                this.m_resourceBundleName = bundleName;
            } else if (this.m_extraResourceBundles == null) {
                this.m_extraResourceBundles = new ResourceBundle[]{PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader())};
            } else {
                ResourceBundle[] oldExtraResBundles = this.m_extraResourceBundles;
                this.m_extraResourceBundles = new ResourceBundle[oldExtraResBundles.length + 1];
                System.arraycopy(oldExtraResBundles, 0, this.m_extraResourceBundles, 0, oldExtraResBundles.length);
                this.m_extraResourceBundles[oldExtraResBundles.length] = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
            }
        }
        catch (MissingResourceException mre) {
            System.err.println("resource bundle " + mre.getClassName() + " not found!");
        }
    }

    public boolean isDebugEnabled() {
        return this.m_logInterface.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_logInterface.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_logInterface.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_logInterface.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_logInterface.isFatalEnabled();
    }

    public void setLevels(long dl, long vl, long fl) {
        this.m_debugLevel = dl;
        this.m_visLevel = vl;
        this.m_facLevel = fl;
    }

    public long getDebugLevel() {
        return this.m_debugLevel;
    }

    public void setDebugLevel(long level) {
        this.m_debugLevel = level;
    }

    public void mergeDebugLevel(long level) {
        this.m_debugLevel |= level;
    }

    public long getVisibilityLevel() {
        return this.m_visLevel;
    }

    public void setVisibilityLevel(long level) {
        this.m_visLevel = level;
    }

    public void mergeVisibilityLevel(long level) {
        this.m_visLevel |= level;
    }

    public long getFacilityCode() {
        return this.m_facLevel;
    }

    public void setFacilityCode(long level) {
        this.m_facLevel = level;
    }

    public void mergeFacilityCode(long level) {
        this.m_facLevel |= level;
    }

    public boolean debugAllowed() {
        return this.debugAllowed(-1L, -1L, -1L);
    }

    public boolean debugAllowed(long dLevel) {
        return this.debugAllowed(dLevel, -1L, -1L);
    }

    public boolean debugAllowed(long dLevel, long vLevel) {
        return this.debugAllowed(dLevel, vLevel, -1L);
    }

    public boolean debugAllowed(long dLevel, long vLevel, long fLevel) {
        return (dLevel & this.m_debugLevel) != 0L && (vLevel & this.m_visLevel) != 0L && (fLevel & this.m_facLevel) != 0L;
    }

    public void debug(long dl, long vl, long fl, Throwable throwable) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(null, null, throwable);
        }
    }

    public void debug(long dl, long vl, long fl, String key, Object[] params) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key, params);
        }
    }

    public void debug(long dl, long vl, long fl, String key) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key);
        }
    }

    public void debug(long dl, long vl, long fl, String key, Throwable throwable) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key, throwable);
        }
    }

    public void debug(long dl, long vl, long fl, String key, Object[] params, Throwable throwable) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key, params, throwable);
        }
    }

    public String getString(String key) throws MissingResourceException {
        String msg = null;
        try {
            msg = this.getResourceBundleString(key);
        }
        catch (MissingResourceException mre) {
            return mre.getLocalizedMessage() + ": [key='" + key + "']";
        }
        return msg;
    }

    public String getString(String key, Object[] params) throws MissingResourceException {
        String pattern = null;
        try {
            pattern = this.getResourceBundleString(key);
        }
        catch (MissingResourceException mre) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i] + ", ");
            }
            return mre.getLocalizedMessage() + ": [key='" + key + "']" + sb.toString();
        }
        String msg = MessageFormat.format(pattern, params);
        return msg;
    }

    public String getString(String base, String key) throws MissingResourceException {
        try {
            ResourceBundle rb = PropertyResourceBundle.getBundle(base, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
            String msg = rb.getString(key);
            return msg;
        }
        catch (MissingResourceException mre) {
            return mre.getLocalizedMessage() + ": [key='" + key + "']";
        }
    }

    public String getString(String base, String key, Object[] params) throws MissingResourceException {
        try {
            ResourceBundle rb = PropertyResourceBundle.getBundle(base, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
            String pattern = rb.getString(key);
            String msg = MessageFormat.format(pattern, params);
            return msg;
        }
        catch (MissingResourceException mre) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i] + ", ");
            }
            return mre.getLocalizedMessage() + ": [key='" + key + "']" + sb.toString();
        }
    }

    protected synchronized String getResourceBundleString(String key) throws MissingResourceException {
        String resource;
        block7: {
            resource = null;
            if (this.m_defaultResourceBundle == null) {
                throw new MissingResourceException("no default resource bundle set for this logger", null, null);
            }
            try {
                resource = this.m_defaultResourceBundle.getString(key);
            }
            catch (MissingResourceException mre) {
                if (this.m_extraResourceBundles == null) {
                    throw mre;
                }
                for (int i = 0; i < this.m_extraResourceBundles.length; ++i) {
                    try {
                        resource = this.m_extraResourceBundles[i].getString(key);
                        continue;
                    }
                    catch (MissingResourceException mre2) {
                        mre = mre2;
                    }
                }
                if (resource != null) break block7;
                throw mre;
            }
        }
        return resource;
    }
}

