/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.xwiki.component.util.ObjectUtils;

public class DefaultParameterizedType
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Class<?> rawType;

    public DefaultParameterizedType(Type ownerType, Class<?> rawType, Type ... actualTypeArguments) {
        this.ownerType = ownerType;
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
    }

    public DefaultParameterizedType(ParameterizedType type) {
        this(type.getOwnerType(), (Class)type.getRawType(), type.getActualTypeArguments());
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ ObjectUtils.hasCode(this.ownerType) ^ ObjectUtils.hasCode(this.rawType);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)o;
        return ObjectUtils.equals(this.rawType, parameterizedType.getRawType()) && ObjectUtils.equals(this.ownerType, parameterizedType.getOwnerType()) && Arrays.equals(this.actualTypeArguments, parameterizedType.getActualTypeArguments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            if (this.ownerType instanceof Class) {
                sb.append(((Class)this.ownerType).getName());
            } else {
                sb.append(this.ownerType.toString());
            }
            sb.append('.');
            if (this.ownerType instanceof ParameterizedType) {
                sb.append(this.rawType.getName().replace(((Class)((ParameterizedType)this.ownerType).getRawType()).getName() + '$', ""));
            } else {
                sb.append(this.rawType.getName());
            }
        } else {
            sb.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            sb.append("< ");
            boolean first = true;
            for (Type type : this.actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                if (type instanceof Class) {
                    sb.append(((Class)type).getName());
                } else {
                    sb.append(type.toString());
                }
                first = false;
            }
            sb.append(" >");
        }
        return sb.toString();
    }
}

