/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.spi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.spi.PortalContext;

public class AbstractPortalContext
implements PortalContext {
    private static final Map<String, String> EMPTY_STRING_TO_STRING_MAP = Collections.emptyMap();
    private static final Set<WindowState> ALL_WINDOW_STATES = Collections.unmodifiableSet(Tools.toSet((Object[])new WindowState[]{WindowState.MAXIMIZED, WindowState.MINIMIZED, WindowState.NORMAL}));
    private static final Set<Mode> ALL_MODES = Collections.unmodifiableSet(Tools.toSet((Object[])new Mode[]{Mode.EDIT, Mode.HELP, Mode.VIEW}));
    private final Set<WindowState> windowStates;
    private final Set<Mode> modes;
    private final Map<String, String> props;

    public AbstractPortalContext(Set<WindowState> windowStates, Set<Mode> modes, Map<String, String> props) {
        if (windowStates == null) {
            throw new IllegalArgumentException("No window states provided");
        }
        if (modes == null) {
            throw new IllegalArgumentException("No modes provided");
        }
        if (props == null) {
            throw new IllegalArgumentException("No properties provided");
        }
        this.windowStates = windowStates;
        this.modes = modes;
        this.props = props;
    }

    public AbstractPortalContext(Map<String, String> props) {
        this(ALL_WINDOW_STATES, ALL_MODES, props);
    }

    public AbstractPortalContext() {
        this(EMPTY_STRING_TO_STRING_MAP);
    }

    public String getInfo() {
        return PortalContext.PORTLET_SPEC_FORMAT.toString(VERSION);
    }

    public Set<WindowState> getWindowStates() {
        return this.windowStates;
    }

    public Set<Mode> getModes() {
        return this.modes;
    }

    public Map<String, String> getProperties() {
        return this.props;
    }
}

