/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MetaData {
    public static final MetaData EMPTY = new MetaData();
    public static final String SOURCE = "source";
    public static final String SYNTAX = "syntax";
    public static final String BASE = "base";
    private Map<String, Object> metadata = new LinkedHashMap<String, Object>();

    public MetaData() {
    }

    public MetaData(Map<String, Object> metaData) {
        this.metadata.putAll(metaData);
    }

    public void addMetaData(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addMetaData(MetaData metaData) {
        for (Map.Entry<String, Object> entry : metaData.getMetaData().entrySet()) {
            this.addMetaData(entry.getKey(), entry.getValue());
        }
    }

    public Object getMetaData(String key) {
        return this.metadata.get(key);
    }

    public boolean contains(String key) {
        return this.metadata.containsKey(key);
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof MetaData && ((Object)this.metadata).equals(((MetaData)obj).metadata);
    }

    public int hashCode() {
        return ((Object)this.metadata).hashCode();
    }
}

