/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ksh" locale.
 */
public class DateTimeFormatInfoImpl_ksh extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "v.m.",
        "n.m."
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, 'dä' d. MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d. MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d. MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "d. M. yyyy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "vür Chrestus",
        "noh Chrestus"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "v.Ch.",
        "n.Ch."
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Jannewa",
        "Fäbrowa",
        "Määz",
        "Aprell",
        "Mäi",
        "Juuni",
        "Juuli",
        "Oujoß",
        "Septämber",
        "Oktoober",
        "Novämber",
        "Dezämber"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Jan.",
        "Fäb.",
        "Mar.",
        "Apr.",
        "Mäi",
        "Jun.",
        "Jul.",
        "Oug.",
        "Säp.",
        "Okt.",
        "Nov.",
        "Dez."
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1. Quattaal",
        "2. Quattaal",
        "3. Quattaal",
        "4. Quattaal"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1.Q.",
        "2.Q.",
        "3.Q.",
        "4.Q."
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "Sunndaach",
        "Moondaach",
        "Dinnsdaach",
        "Metwoch",
        "Dunnersdaach",
        "Friidaach",
        "Samsdaach"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "M",
        "D",
        "M",
        "D",
        "F",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Su.",
        "Mo.",
        "Di.",
        "Me.",
        "Du.",
        "Fr.",
        "Sa."
    };
  }
}
