/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.Dom4jComponentTuplizer;
import org.hibernate.tuple.component.DynamicMapComponentTuplizer;
import org.hibernate.tuple.component.PojoComponentTuplizer;
import org.hibernate.util.FastHashMap;
import org.hibernate.util.ReflectHelper;

public class ComponentTuplizerFactory
implements Serializable {
    private static final Class[] COMPONENT_TUP_CTOR_SIG;
    private Map defaultImplClassByMode = ComponentTuplizerFactory.buildBaseMapping();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void registerDefaultTuplizerClass(EntityMode entityMode, Class tuplizerClass) {
        if (!$assertionsDisabled && !this.isComponentTuplizerImplementor(tuplizerClass)) {
            throw new AssertionError((Object)("Specified tuplizer class [" + tuplizerClass.getName() + "] does not implement " + ComponentTuplizer.class.getName()));
        }
        if (!$assertionsDisabled && !this.hasProperConstructor(tuplizerClass)) {
            throw new AssertionError((Object)("Specified tuplizer class [" + tuplizerClass.getName() + "] is not properly instantiatable"));
        }
        this.defaultImplClassByMode.put(entityMode, tuplizerClass);
    }

    public ComponentTuplizer constructTuplizer(String tuplizerClassName, Component metadata) {
        try {
            Class tuplizerClass = ReflectHelper.classForName(tuplizerClassName);
            return this.constructTuplizer(tuplizerClass, metadata);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Could not locate specified tuplizer class [" + tuplizerClassName + "]");
        }
    }

    public ComponentTuplizer constructTuplizer(Class tuplizerClass, Component metadata) {
        Constructor ctor = this.getProperConstructor(tuplizerClass);
        if (!$assertionsDisabled && ctor == null) {
            throw new AssertionError((Object)("Unable to locate proper constructor for tuplizer [" + tuplizerClass.getName() + "]"));
        }
        try {
            return (ComponentTuplizer)ctor.newInstance(metadata);
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate default tuplizer [" + tuplizerClass.getName() + "]", t);
        }
    }

    public ComponentTuplizer constructDefaultTuplizer(EntityMode entityMode, Component metadata) {
        Class tuplizerClass = (Class)this.defaultImplClassByMode.get(entityMode);
        if (tuplizerClass == null) {
            throw new HibernateException("could not determine default tuplizer class to use [" + entityMode + "]");
        }
        return this.constructTuplizer(tuplizerClass, metadata);
    }

    private boolean isComponentTuplizerImplementor(Class tuplizerClass) {
        return ReflectHelper.implementsInterface(tuplizerClass, ComponentTuplizer.class);
    }

    private boolean hasProperConstructor(Class tuplizerClass) {
        return this.getProperConstructor(tuplizerClass) != null;
    }

    private Constructor getProperConstructor(Class clazz) {
        Constructor ctor = null;
        try {
            ctor = clazz.getDeclaredConstructor(COMPONENT_TUP_CTOR_SIG);
            if (!ReflectHelper.isPublic(ctor)) {
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException e) {
                    ctor = null;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ctor;
    }

    private static Map buildBaseMapping() {
        FastHashMap map = new FastHashMap();
        map.put(EntityMode.POJO, PojoComponentTuplizer.class);
        map.put(EntityMode.DOM4J, Dom4jComponentTuplizer.class);
        map.put(EntityMode.MAP, DynamicMapComponentTuplizer.class);
        return map;
    }

    static {
        $assertionsDisabled = !ComponentTuplizerFactory.class.desiredAssertionStatus();
        COMPONENT_TUP_CTOR_SIG = new Class[]{Component.class};
    }
}

