/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.utils.text;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class Text {
    public static String escape(String string, char escape, boolean isPath) {
        return Text.escape(string, escape, isPath, "");
    }

    public static String escape(String string, char escape, boolean isPath, String extraCharacters) {
        try {
            BitSet validChars = isPath ? org.exoplatform.services.jcr.util.Text.URISaveEx : org.exoplatform.services.jcr.util.Text.URISave;
            BitSet extraBitSet = (BitSet)org.exoplatform.services.jcr.util.Text.URISave.clone();
            for (char c : extraCharacters.toCharArray()) {
                extraBitSet.set(c);
            }
            byte[] bytes = string.getBytes("utf-8");
            StringBuffer out = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                int n = bytes[i] & 0xFF;
                if ((validChars.get(n) || extraBitSet.get(n)) && n != escape) {
                    out.append((char)n);
                    continue;
                }
                out.append(escape);
                out.append(org.exoplatform.services.jcr.util.Text.hexTable[n >> 4 & 0xF]);
                out.append(org.exoplatform.services.jcr.util.Text.hexTable[n & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public static String escapeIllegalJcrChars(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '&' || ch == '#' || ch == '*' || ch == '@' || ch == '\'' || ch == '\"' || ch == '|' || ch == '.' && name.length() < 3 || ch == ' ' && (i == 0 || i == name.length() - 1) || ch == '\t' || ch == '\r' || ch == '\n' || ch == '\\' || ch == '>' || ch == '<') {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String unescapeIllegalJcrChars(String name) {
        return org.exoplatform.services.jcr.util.Text.unescapeIllegalJcrChars((String)name);
    }
}

