/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ks.upgrade.UpgradeUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.ModelImpl;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;

public class UpgradeWikiPlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeWikiPlugin.class);

    public UpgradeWikiPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        log.info((Object)String.format("\n\n\n\n -----------> Migrating data from %s to %s for Wiki......\n\n\n", oldVersion, newVersion));
        try {
            log.info((Object)"\n\nRegister new nodeTypes...\n");
            UpgradeUtils.registerNodeTypes("jar:/conf/portal/wiki-migrate-nodetypes.xml", 4);
        }
        catch (Exception e) {
            log.warn((Object)String.format("[UpgradeWikiPlugin] Exception when migrate data from %s to %s for Wiki.", oldVersion, newVersion), (Throwable)e);
        }
        try {
            log.info((Object)"\n\nCheck and remove old help data...\n");
            this.removeOldHelpData();
        }
        catch (Exception e) {
            log.warn((Object)"[UpgradeWikiPlugin] Exception when Check and remove old help data for wiki:", (Throwable)e);
        }
        log.info((Object)"\n\n\n\n -----------> End Wiki Migration......\n\n\n");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }

    public void removeOldHelpData() throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        ModelImpl model = mowService.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        for (PageImpl syntaxPage : wStore.getHelpPagesContainer().getChildPages().values()) {
            if (syntaxPage.getName().toLowerCase().indexOf("xwiki") > -1) continue;
            syntaxPage.remove();
        }
        RequestLifeCycle.end();
    }
}

