/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.selector;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.forum.service.cache.model.data.CategoryData;
import org.exoplatform.forum.service.cache.model.key.CategoryKey;
import org.exoplatform.ks.common.cache.model.ScopeCacheKey;
import org.exoplatform.ks.common.cache.model.selector.ScopeCacheSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryIdSelector
extends ScopeCacheSelector<ScopeCacheKey, Object> {
    private final List<String> cateIds;
    private final ExoCache<CategoryKey, CategoryData> selector;

    public CategoryIdSelector(List<String> cateIds, ExoCache<CategoryKey, CategoryData> selector) {
        if (cateIds == null) {
            throw new NullPointerException();
        }
        if (selector == null) {
            throw new NullPointerException();
        }
        this.cateIds = cateIds;
        this.selector = selector;
    }

    public boolean select(ScopeCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
        if (!super.select(key, ocinfo)) {
            return false;
        }
        CategoryData data = (CategoryData)this.selector.get((Serializable)key);
        if (data == null) {
            return false;
        }
        for (String path : this.cateIds) {
            if (!data.getId().equals(path)) continue;
            return true;
        }
        return false;
    }
}

