/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileFinder {
    private static final Log LOG = ExoLogger.getLogger(FileFinder.class);
    private List<String> fileList = new ArrayList<String>();

    public FileFinder(String path) {
        if (path.indexOf(";") >= 0) {
            String[] pathes;
            for (String p : pathes = path.split(";")) {
                if (p.isEmpty()) continue;
                this.findForFiles(p);
            }
        } else {
            this.findForFiles(path);
        }
    }

    public List<String> getFileList() {
        return this.fileList;
    }

    private void findForFiles(String fileMask) {
        block4: {
            fileMask = fileMask.trim();
            try {
                File file = new File(fileMask);
                if (file.isFile() && file.exists()) {
                    this.fileList.add(fileMask);
                } else {
                    this.findForFilesByMask(fileMask);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findForFilesByMask(String fileMask) {
        if (fileMask.contains("/")) {
            try {
                String directory = fileMask.substring(0, fileMask.lastIndexOf("/"));
                String fileNamePattern = fileMask.substring(fileMask.lastIndexOf("/") + 1);
                File directoryContent = new File(directory);
                String[] files = directoryContent.list(new Filter(fileNamePattern));
                if (files == null) {
                    return;
                }
                for (String f : files) {
                    this.fileList.add(directory + File.separator + f);
                }
                return;
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) return;
                e.printStackTrace();
                return;
            }
        } else {
            LOG.info((Object)"This case is not implemented!");
        }
    }

    private class Filter
    implements FilenameFilter {
        private String startWith;
        private String endWith;
        private String fileName;

        public Filter(String fileNamePattern) {
            if (fileNamePattern.contains("*")) {
                this.startWith = fileNamePattern.substring(0, fileNamePattern.indexOf("*"));
                this.endWith = fileNamePattern.substring(fileNamePattern.lastIndexOf("*") + 1);
            } else {
                this.fileName = fileNamePattern;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.fileName != null ? this.fileName.equalsIgnoreCase(name) : name.startsWith(this.startWith) && name.endsWith(this.endWith);
        }
    }
}

