/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIAddLanguageContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UILanguageDialogForm;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/UIFormWithoutAction.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ChangeLanguageActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SetDefaultActionListener.class})})
public class UILanguageTypeForm
extends UIForm {
    public static final String LANGUAGE_TYPE = "typeLang";
    public static final String DEFAULT_TYPE = "default";

    public UILanguageTypeForm() throws Exception {
        UIFormSelectBox uiSelectForm = new UIFormSelectBox(LANGUAGE_TYPE, LANGUAGE_TYPE, this.languages());
        uiSelectForm.setOnChange("ChangeLanguage");
        this.addUIFormInput((UIFormInput)uiSelectForm);
        UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(DEFAULT_TYPE, DEFAULT_TYPE, null);
        uiCheckbox.setOnChange("SetDefault");
        this.addUIFormInput((UIFormInput)uiCheckbox);
    }

    public void resetLanguage() {
        this.getUIFormSelectBox(LANGUAGE_TYPE).setValue("");
        this.getUIFormCheckBoxInput(DEFAULT_TYPE).setChecked(false);
    }

    public List<SelectItemOption<String>> languages() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale());
        LocaleConfigService localService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        ArrayList<SelectItemOption<String>> languages = new ArrayList<SelectItemOption<String>>();
        Iterator iter = localService.getLocalConfigs().iterator();
        languages.add(new SelectItemOption("- - - -", (Object)""));
        while (iter.hasNext()) {
            LocaleConfig localConfig = (LocaleConfig)iter.next();
            languages.add((SelectItemOption<String>)new SelectItemOption(localConfig.getLocale().getDisplayLanguage(), (Object)localConfig.getLocale().getLanguage()));
        }
        Locale.setDefault(defaultLocale);
        return languages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDefaultActionListener
    extends EventListener<UILanguageTypeForm> {
        public void execute(Event<UILanguageTypeForm> event) throws Exception {
            UILanguageTypeForm uiForm = (UILanguageTypeForm)((Object)event.getSource());
            UIAddLanguageContainer uiLanguageContainer = (UIAddLanguageContainer)uiForm.getParent();
            boolean isDefault = uiForm.getUIFormCheckBoxInput(UILanguageTypeForm.DEFAULT_TYPE).isChecked();
            if (uiLanguageContainer.nodeTypeName_ != null) {
                UILanguageDialogForm uiDialogForm = (UILanguageDialogForm)uiLanguageContainer.getChild(UILanguageDialogForm.class);
                uiDialogForm.setIsDefaultLanguage(isDefault);
            } else {
                UISingleUploadForm uiUploadForm = (UISingleUploadForm)uiLanguageContainer.findFirstComponentOfType(UISingleUploadForm.class);
                uiUploadForm.setIsDefaultLanguage(isDefault);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UILanguageTypeForm> {
        public void execute(Event<UILanguageTypeForm> event) throws Exception {
            UILanguageTypeForm uiTypeForm = (UILanguageTypeForm)((Object)event.getSource());
            String selectedLang = ((String)uiTypeForm.getUIFormSelectBox(UILanguageTypeForm.LANGUAGE_TYPE).getValue()).trim();
            MultiLanguageService multiLanguageService = (MultiLanguageService)uiTypeForm.getApplicationComponent(MultiLanguageService.class);
            if (selectedLang == null || selectedLang.length() < 1) {
                return;
            }
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTypeForm.getAncestorOfType(UIJCRExplorer.class);
            UIAddLanguageContainer uiContainer = (UIAddLanguageContainer)uiTypeForm.getParent();
            if (uiContainer.nodeTypeName_ != null) {
                UILanguageDialogForm uiDialogForm = (UILanguageDialogForm)uiContainer.getChild(UILanguageDialogForm.class);
                uiDialogForm.getChildren().clear();
                uiDialogForm.setTemplateNode(uiContainer.nodeTypeName_);
                Node node = uiExplorer.getCurrentNode();
                String currentPath = node.getPath();
                if (selectedLang.equals(multiLanguageService.getDefault(node))) {
                    uiTypeForm.getUIFormCheckBoxInput(UILanguageTypeForm.DEFAULT_TYPE).setChecked(true);
                    uiTypeForm.getUIFormCheckBoxInput(UILanguageTypeForm.DEFAULT_TYPE).setEnable(false);
                } else {
                    uiTypeForm.getUIFormCheckBoxInput(UILanguageTypeForm.DEFAULT_TYPE).setChecked(false);
                    uiTypeForm.getUIFormCheckBoxInput(UILanguageTypeForm.DEFAULT_TYPE).setEnable(true);
                }
                if (node.hasNode("languages")) {
                    Node languagesNode = node.getNode("languages");
                    if (node.isNodeType("nt:file")) {
                        uiDialogForm.setIsNTFile(true);
                        uiDialogForm.setIsAddNew(false);
                    } else {
                        uiDialogForm.setIsNTFile(false);
                    }
                    if (languagesNode.hasNode(selectedLang)) {
                        if (node.isNodeType("nt:unstructured") || node.isNodeType("nt:folder")) {
                            uiDialogForm.setNodePath(languagesNode.getNode(selectedLang).getNode(node.getName()).getPath());
                        } else {
                            uiDialogForm.setNodePath(languagesNode.getNode(selectedLang).getPath());
                        }
                    } else if (selectedLang.equals(multiLanguageService.getDefault(node))) {
                        uiDialogForm.setNodePath(currentPath);
                    } else {
                        uiDialogForm.setNodePath(currentPath);
                        uiDialogForm.setIsNotEditNode(true);
                        uiDialogForm.setIsResetMultiField(true);
                        uiDialogForm.seti18nNodePath(currentPath);
                    }
                } else if (!node.hasNode("languages") && selectedLang.equals(multiLanguageService.getDefault(node))) {
                    uiDialogForm.setIsNotEditNode(false);
                    uiDialogForm.setNodePath(currentPath);
                } else {
                    uiDialogForm.setNodePath(currentPath);
                    uiDialogForm.seti18nNodePath(currentPath);
                    uiDialogForm.setIsNotEditNode(true);
                    uiDialogForm.setIsResetMultiField(true);
                }
                uiDialogForm.seti18nNodePath(currentPath);
                uiDialogForm.setSelectedLanguage(selectedLang);
                if (selectedLang.equals(node.getProperty("exo:language").getString())) {
                    uiDialogForm.setChildPath(currentPath);
                } else if (node.hasNode("languages/" + selectedLang)) {
                    uiDialogForm.getChildren().clear();
                    Node languageNode = multiLanguageService.getLanguage(node, selectedLang);
                    if (node.isNodeType("nt:unstructured") || node.isNodeType("nt:folder")) {
                        uiDialogForm.setChildPath(languageNode.getNode(node.getName()).getPath());
                    } else {
                        uiDialogForm.setChildPath(languageNode.getPath());
                    }
                } else {
                    uiDialogForm.getChildren().clear();
                    uiDialogForm.setChildPath(null);
                }
            } else {
                UISingleUploadForm uiUploadForm = (UISingleUploadForm)uiContainer.findFirstComponentOfType(UISingleUploadForm.class);
                uiUploadForm.setIsMultiLanguage(true, selectedLang);
            }
            uiContainer.setRenderSibling(UIAddLanguageContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }
}

