/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.Validate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIConfirmMessage;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanDeleteNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={DeleteActionListener.class})})
public class DeleteManageComponent
extends UIAbstractManagerComponent {
    private static final Log LOG = ExoLogger.getLogger((String)DeleteManageComponent.class.getName());
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotLockedFilter(), new CanDeleteNodeFilter(), new IsNotTrashHomeNodeFilter(), new IsNotEditingDocumentFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private void processRemoveMultiple(String[] nodePaths, Event<?> event) throws Exception {
        HashMap<String, Node> mapNode = new HashMap<String, Node>();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        for (int i = 0; i < nodePaths.length; ++i) {
            try {
                Node node = this.getNodeByPath(nodePaths[i]);
                Validate.isTrue((node != null ? 1 : 0) != 0, (String)("The ObjectId is invalid '" + nodePaths[i] + "'"));
                mapNode.put(node.getPath(), node);
                continue;
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                continue;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
        }
        String path2 = null;
        for (String path2 : mapNode.keySet()) {
            this.processRemoveOrMoveToTrash(path2, (Node)mapNode.get(path2), event, true, true);
        }
    }

    private void removeMixins(Node node) throws Exception {
        NodeType[] mixins;
        for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
            node.removeMixin(nodeType.getName());
        }
    }

    private void removeAuditForNode(Node node) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ManageableRepository repository = uiExplorer.getRepository();
        SessionProvider sessionProvider = uiExplorer.getSystemProvider();
        Session session = null;
        session = sessionProvider.getSession(node.getSession().getWorkspace().getName(), repository);
        if (session.getRootNode().hasNode("exo:audit") && session.getRootNode().getNode("exo:audit").hasNode(node.getUUID())) {
            session.getRootNode().getNode("exo:audit").getNode(node.getUUID()).remove();
            session.save();
        }
    }

    private void processRemoveOrMoveToTrash(String nodePath, Node node, Event<?> event, boolean isMultiSelect, boolean checkToMoveToTrash) throws Exception {
        if (Utils.isInTrash((Node)node) || !checkToMoveToTrash) {
            this.processRemoveNode(nodePath, node, event, isMultiSelect);
        } else {
            boolean moveOK;
            WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
            List categories = ((TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class)).getAllCategories(node);
            String parentPath = node.getParent().getPath();
            String parentWSpace = node.getSession().getWorkspace().getName();
            wcmComposer.updateContent(parentWSpace, node.getPath(), new HashMap());
            boolean isNodeReferenceable = Utils.isReferenceable((Node)node);
            String nodeUUID = null;
            if (isNodeReferenceable) {
                nodeUUID = node.getUUID();
            }
            if (moveOK = this.moveToTrash(nodePath, node, event, isMultiSelect)) {
                for (Node categoryNode : categories) {
                    wcmComposer.updateContents(categoryNode.getSession().getWorkspace().getName(), categoryNode.getPath(), new HashMap());
                }
                PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
                PortletPreferences portletPref = pcontext.getRequest().getPreferences();
                String trashWorkspace = portletPref.getValue("trashWorkspace", "");
                if (isNodeReferenceable) {
                    wcmComposer.updateContent(trashWorkspace, nodeUUID, new HashMap());
                }
                wcmComposer.updateContents(parentWSpace, parentPath, new HashMap());
            }
        }
    }

    private boolean moveToTrash(String srcPath, Node node, Event<?> event, boolean isMultiSelect) throws Exception {
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        TrashService trashService = (TrashService)myContainer.getComponentInstanceOfType(TrashService.class);
        boolean ret = true;
        String virtualNodePath = srcPath;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return false;
        }
        try {
            if (node.isLocked()) {
                LockUtil.removeLock((Node)node);
                node.unlock();
            }
            RelationsService relationService = (RelationsService)uiApp.getApplicationComponent(RelationsService.class);
            PropertyIterator iter = node.getReferences();
            while (iter.hasNext()) {
                Node refNode = iter.nextProperty().getParent();
                relationService.removeRelation(refNode, node.getPath());
            }
            if (!node.isCheckedOut()) {
                throw new VersionException("node is locked, can't move to trash node :" + node.getPath());
            }
            if (!PermissionUtil.canRemoveNode((Node)node)) {
                throw new AccessDeniedException("access denied, can't move to trash node:" + node.getPath());
            }
            SessionProvider sessionProvider = uiExplorer.getSessionProvider();
            Node currentNode = uiExplorer.getCurrentNode();
            try {
                trashService.moveToTrash(node, sessionProvider);
            }
            catch (PathNotFoundException ex) {
                ret = false;
            }
            String currentPath = LinkUtils.getExistPath((Node)currentNode, (String)uiExplorer.getCurrentPath());
            uiExplorer.setCurrentPath(currentPath);
            uiExplorer.updateAjax(event);
        }
        catch (LockException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is locked, can't move to trash node :" + node.getPath()));
            }
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.can-not-remove-locked-node", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (VersionException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is checked in, can't move to trash node:" + node.getPath()));
            }
            this.removeMixinEXO_RESTORE_LOCATION(node);
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.can-not-remove-checked-in-node", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (AccessDeniedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("access denied, can't move to trash node:" + node.getPath()));
            }
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.access-denied-to-delete", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            }
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.unexpected-error", (Object[])new String[]{node.getPath()}, 0));
            uiExplorer.updateAjax(event);
            ret = false;
        }
        if (!isMultiSelect) {
            if (uiExplorer.getCurrentPath().equals(virtualNodePath)) {
                uiExplorer.setSelectNode(LinkUtils.getParentPath((String)virtualNodePath));
            } else {
                uiExplorer.setSelectNode(uiExplorer.getCurrentPath());
            }
        }
        return ret;
    }

    private void processRemoveNode(String nodePath, Node node, Event<?> event, boolean isMultiSelect) throws Exception {
        String virtualNodePath = nodePath;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiExplorer.getCurrentNode();
        Session session = node.getSession();
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        Node parentNode = node.getParent();
        uiExplorer.addLockToken(parentNode);
        try {
            TaxonomyService taxonomyService = (TaxonomyService)uiExplorer.getApplicationComponent(TaxonomyService.class);
            List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
            List listExistedTaxonomy = taxonomyService.getAllCategories(node);
            block8: for (Node existedTaxonomy : listExistedTaxonomy) {
                for (Node taxonomyTrees : listTaxonomyTrees) {
                    if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                    taxonomyService.removeCategory(node, taxonomyTrees.getName(), existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                    continue block8;
                }
            }
            if (node.isNodeType("rma:record")) {
                this.removeMixins(node);
            }
            ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
            actionService.removeAction(node, uiExplorer.getRepositoryName());
            ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
            thumbnailService.processRemoveThumbnail(node);
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
            newFolksonomyService.removeTagsOfNodeRecursively(node, uiExplorer.getRepository().getConfiguration().getDefaultWorkspaceName(), node.getSession().getUserID(), this.getGroups());
            if (PermissionUtil.canRemoveNode((Node)node) && node.isNodeType("exo:auditable")) {
                this.removeAuditForNode(node);
            }
            node.remove();
            parentNode.save();
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ReferentialIntegrityException ref) {
            session.refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ConstraintViolationException cons) {
            session.refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LockException lockException) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-other-person", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        if (!isMultiSelect) {
            if (currentNode.getPath().equals(virtualNodePath)) {
                uiExplorer.setSelectNode(LinkUtils.getParentPath((String)virtualNodePath));
            } else {
                uiExplorer.setSelectNode(currentNode.getPath());
            }
        }
    }

    private void processRemoveMultiple(String[] nodePaths, String[] wsNames, Event<?> event) throws Exception {
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processRemove(nodePaths[i], wsNames[i], event, true);
        }
    }

    private void processRemove(String nodePath, String wsName, Event<?> event, boolean isMultiSelect) throws Exception {
        if (wsName == null) {
            wsName = this.getDefaultWorkspace();
        }
        this.doDelete(wsName.concat(":").concat(nodePath), event);
    }

    private String getDefaultWorkspace() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getCurrentDriveWorkspace();
    }

    public void doDelete(String nodePath, String wsName, Event<?> event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (nodePath.indexOf(";") > -1) {
            this.processRemoveMultiple(nodePath.split(";"), wsName.split(";"), event);
        } else {
            this.processRemove(nodePath, wsName, event, false);
        }
        uiExplorer.updateAjax(event);
        uiExplorer.getSession().save();
    }

    public void doDeleteWithoutTrash(String nodePath, Event<?> event) throws Exception {
        this.doDelete(nodePath, event, false);
    }

    public void doDelete(String nodePath, Event<?> event) throws Exception {
        this.doDelete(nodePath, event, true);
    }

    public void doDelete(String nodePath, Event<?> event, boolean checkToMoveToTrash) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (nodePath.indexOf(";") > -1) {
            this.processRemoveMultiple(nodePath.split(";"), event);
        } else {
            UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
            try {
                Node node = this.getNodeByPath(nodePath);
                if (node != null) {
                    this.processRemoveOrMoveToTrash(node.getPath(), node, event, false, checkToMoveToTrash);
                }
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
        uiExplorer.updateAjax(event);
        uiExplorer.getSession().save();
    }

    public static void deleteManage(Event<? extends UIComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
        UIConfirmMessage uiConfirmMessage = (UIConfirmMessage)uiWorkingArea.createUIComponent(UIConfirmMessage.class, null, null);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        List<String> listNodesHaveRelations = null;
        try {
            listNodesHaveRelations = DeleteManageComponent.checkRelations(nodePath, uiExplorer);
        }
        catch (PathNotFoundException pathEx) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        if (listNodesHaveRelations != null && listNodesHaveRelations.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < listNodesHaveRelations.size(); ++i) {
                sb.append("'").append(listNodesHaveRelations.get(i)).append("', ");
            }
            String strNodesHaveRelations = sb.substring(0, sb.length() - 2);
            if (nodePath.indexOf(";") < 0) {
                uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-has-relations");
                uiConfirmMessage.setArguments(new String[]{nodePath});
            } else if (listNodesHaveRelations.size() > 1) {
                uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-multi-many-nodes-have-relations");
                uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length), strNodesHaveRelations});
            } else {
                uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-multi-one-node-has-relations");
                uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length), strNodesHaveRelations});
            }
        } else if (DeleteManageComponent.isInTrashFolder(nodePath, uiExplorer)) {
            if (nodePath.indexOf(";") > -1) {
                uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-permanently-multi");
                uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length)});
            } else {
                uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-permanently");
                uiConfirmMessage.setArguments(new String[]{nodePath});
            }
        } else if (nodePath.indexOf(";") > -1) {
            uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-multi");
            uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length)});
        } else {
            uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete");
            uiConfirmMessage.setArguments(new String[]{nodePath});
        }
        uiConfirmMessage.setNodePath(nodePath);
        UIPopupContainer2.activate((UIComponent)uiConfirmMessage, 500, 180);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
    }

    private static boolean isInTrashFolder(String nodePath, UIJCRExplorer uiExplorer) throws Exception {
        String wsName = null;
        Session session = null;
        String[] nodePaths = nodePath.split(";");
        for (int i = 0; i < nodePaths.length; ++i) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePaths[i]);
            if (!matcher.find()) continue;
            wsName = matcher.group(1);
            nodePath = matcher.group(2);
            session = uiExplorer.getSessionByWorkspace(wsName);
            Node node = uiExplorer.getNodeByPath(nodePath, session, false);
            return Utils.isInTrash((Node)node);
        }
        return false;
    }

    private static List<String> checkRelations(String nodePath, UIJCRExplorer uiExplorer) throws Exception {
        Node node = null;
        String wsName = null;
        Session session = null;
        String[] nodePaths = nodePath.split(";");
        ArrayList<String> listNodesHaveRelations = new ArrayList<String>();
        for (int i = 0; i < nodePaths.length; ++i) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePaths[i]);
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                node = uiExplorer.getNodeByPath(nodePath, session = uiExplorer.getSessionByWorkspace(wsName), false);
                if (node.getReferences().getSize() <= 0L) continue;
                listNodesHaveRelations.add(nodePath);
                continue;
            }
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        return listNodesHaveRelations;
    }

    private Node getNodeByPath(String nodePath) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        if (!matcher.find()) {
            return null;
        }
        String wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        return uiExplorer.getNodeByPath(nodePath, session, false);
    }

    private String getGroups() throws Exception {
        StringBuilder ret = new StringBuilder();
        for (String group : Utils.getGroups()) {
            ret.append(group).append(';');
        }
        ret.deleteCharAt(ret.length() - 1);
        return ret.toString();
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    private void removeMixinEXO_RESTORE_LOCATION(Node node) throws Exception {
        if (node.isNodeType("exo:restoreLocation")) {
            node.removeMixin("exo:restoreLocation");
            node.save();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends UIWorkingAreaActionListener<DeleteManageComponent> {
        public void processEvent(Event<DeleteManageComponent> event) throws Exception {
            DeleteManageComponent.deleteManage(event);
        }
    }
}

