/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import javax.jcr.Node;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.versions.UIVersionInfo;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UILabelForm
extends UIForm {
    private static String FIELD_LABEL = "label";

    public UILabelForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL, FIELD_LABEL, null).addValidator(MandatoryValidator.class, new Object[0]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UILabelForm> {
        public void execute(Event<UILabelForm> event) throws Exception {
            UILabelForm uiLabelForm = (UILabelForm)((Object)event.getSource());
            uiLabelForm.reset();
            uiLabelForm.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiLabelForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UILabelForm> {
        public void execute(Event<UILabelForm> event) throws Exception {
            UILabelForm uiLabelForm = (UILabelForm)((Object)event.getSource());
            String label = ((String)uiLabelForm.getUIStringInput(FIELD_LABEL).getValue()).trim();
            UIVersionInfo uiVersionInfo = (UIVersionInfo)uiLabelForm.getParent();
            VersionNode currentVersion = uiVersionInfo.getCurrentVersionNode();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiLabelForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiLabelForm.getAncestorOfType(UIApplication.class);
            Node currentNode = uiExplorer.getCurrentNode();
            if (!Utils.isNameValid((String)label, (String[])Utils.SPECIALCHARACTER)) {
                uiApp.addMessage(new ApplicationMessage("UILabelForm.msg.label-invalid", null, 1));
                return;
            }
            try {
                currentNode.getVersionHistory().addVersionLabel(currentVersion.getName(), label, false);
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UILabelForm.msg.label-exist", new Object[]{label}));
                return;
            }
            uiLabelForm.reset();
            uiLabelForm.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }
}

