/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DB2DBInitializer
extends StorageDBInitializer {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DB2DBInitializer");

    public DB2DBInitializer(String containerName, Connection connection, String scriptPath, boolean multiDb) throws IOException {
        super(containerName, connection, scriptPath, multiDb);
    }

    protected boolean isSequenceExists(final Connection conn, final String sequenceName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return DB2DBInitializer.this.sequenceExists(sequenceName, conn);
            }
        });
    }

    private int getSequenceStartValue(final Connection conn) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return DB2DBInitializer.this.getStartValue(conn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sequenceExists(String sequenceName, Connection con) {
        boolean bl;
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String query = "SELECT count(*) FROM SYSCAT.SEQUENCES WHERE SYSCAT.SEQUENCES.SEQNAME = '" + sequenceName + "'";
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            bl = trs.next() && trs.getInt(1) >= 1;
            Object var8_9 = null;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQLException occurs while checking the sequence " + sequenceName), (Throwable)e);
                }
                bl2 = false;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                JDBCUtils.freeResources(trs, stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources(trs, stmt, null);
            return bl2;
        }
        JDBCUtils.freeResources(trs, stmt, null);
        return bl;
    }

    protected String updateQuery(String sql) {
        try {
            if (this.creatSequencePattern.matcher(sql).find()) {
                sql = sql.concat(" Start with " + Integer.toString(this.getSequenceStartValue(this.connection)));
            }
        }
        catch (SQLException e) {
            LOG.debug((Object)"SQLException occurs while update the sequence start value", (Throwable)e);
        }
        return sql;
    }
}

