/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.component;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;
import org.picocontainer.PicoContainer;

public class ThreadContextHandler {
    private final ExoContainer container;
    private List<ThreadContext> contexts;

    public ThreadContextHandler(ExoContainer container) {
        this.container = container;
    }

    public void store() {
        final ArrayList components = new ArrayList(this.container.getComponentInstancesOfType(ThreadContextHolder.class));
        for (PicoContainer current = this.container.getParent(); current != null; current = current.getParent()) {
            components.addAll(current.getComponentInstancesOfType(ThreadContextHolder.class));
        }
        this.contexts = new ArrayList<ThreadContext>(components.size());
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                int length = components.size();
                for (int i = 0; i < length; ++i) {
                    ThreadContextHolder holder = (ThreadContextHolder)components.get(i);
                    ThreadContext tc = holder.getThreadContext();
                    if (tc == null) continue;
                    ThreadContextHandler.this.contexts.add(tc);
                    tc.store();
                }
                return null;
            }
        });
    }

    public void push() {
        if (this.contexts == null) {
            throw new IllegalStateException("No values have been set, the store method has not been called or failed");
        }
        int length = this.contexts.size();
        for (int i = 0; i < length; ++i) {
            ThreadContext tc = this.contexts.get(i);
            tc.push();
        }
    }

    public void restore() {
        if (this.contexts == null) {
            throw new IllegalStateException("No values have been set, the store method has not been called or failed");
        }
        int length = this.contexts.size();
        for (int i = 0; i < length; ++i) {
            ThreadContext tc = this.contexts.get(i);
            tc.restore();
        }
        this.contexts.clear();
    }
}

