/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.metadata.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataServiceImpl
implements MetadataService,
Startable {
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String INTERNAL_USE = "exo:internalUse".intern();
    public static final String METADATA_TYPE = "exo:metadata".intern();
    public static final String DIALOGS = "dialogs";
    public static final String VIEWS = "views";
    public static final String DIALOG1 = "dialog1";
    public static final String VIEW1 = "view1";
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String baseMetadataPath_;
    private List<TemplatePlugin> plugins_ = new ArrayList<TemplatePlugin>();
    private DMSConfiguration dmsConfiguration_;
    private static final Log LOG = ExoLogger.getLogger(MetadataServiceImpl.class);
    private TemplateService templateService;

    public MetadataServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, DMSConfiguration dmsConfiguration) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.baseMetadataPath_ = this.nodeHierarchyCreator_.getJcrPath("metadataPath");
        this.dmsConfiguration_ = dmsConfiguration;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    public void stop() {
    }

    public void addPlugins(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    private void init() throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            try {
                plugin.setBasePath(this.baseMetadataPath_);
                plugin.init();
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    @Override
    public void init(String repository) throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            try {
                plugin.setBasePath(this.baseMetadataPath_);
                plugin.init(repository);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    @Override
    public String addMetadata(String nodetype, boolean isDialog, String role, String content, boolean isAddNew, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        String path = null;
        if (!isAddNew) {
            if (isDialog) {
                Node dialog1 = metadataHome.getNode(nodetype).getNode(DIALOGS).getNode(DIALOG1);
                path = this.templateService.updateTemplate(dialog1, new ByteArrayInputStream(content.getBytes()), role.split(";"));
            } else {
                Node view1 = metadataHome.getNode(nodetype).getNode(VIEWS).getNode(VIEW1);
                path = this.templateService.updateTemplate(view1, new ByteArrayInputStream(content.getBytes()), role.split(";"));
            }
        } else {
            Node metadata = null;
            metadata = metadataHome.hasNode(nodetype) ? metadataHome.getNode(nodetype) : metadataHome.addNode(nodetype, NT_UNSTRUCTURED);
            this.addTemplate(metadata, role, new ByteArrayInputStream(content.getBytes()), isDialog);
            metadataHome.save();
        }
        session.save();
        return path;
    }

    private void addTemplate(Node nodetype, String role, InputStream content, boolean isDialog) throws Exception {
        Node templateHome = this.createTemplateHome(nodetype, isDialog);
        String[] arrRoles = new String[]{};
        if (role != null) {
            arrRoles = role.split(";");
        }
        if (isDialog) {
            this.templateService.createTemplate(templateHome, DIALOG1, content, arrRoles);
        } else {
            this.templateService.createTemplate(templateHome, VIEW1, content, arrRoles);
        }
    }

    @Override
    public void removeMetadata(String nodetype, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node metadata = metadataHome.getNode(nodetype);
        metadata.remove();
        metadataHome.save();
        session.save();
    }

    @Override
    public List<String> getMetadataList(String repository) throws Exception {
        ArrayList<String> metadataTypes = new ArrayList<String>();
        for (NodeType metadata : this.getAllMetadatasNodeType(repository)) {
            metadataTypes.add(metadata.getName());
        }
        return metadataTypes;
    }

    @Override
    public List<NodeType> getAllMetadatasNodeType(String repository) throws Exception {
        ArrayList<NodeType> metadataTypes = new ArrayList<NodeType>();
        ExtendedNodeTypeManager ntManager = this.repositoryService_.getRepository(repository).getNodeTypeManager();
        NodeTypeIterator ntIter = ntManager.getMixinNodeTypes();
        while (ntIter.hasNext()) {
            NodeType nt = ntIter.nextNodeType();
            if (!nt.isNodeType(METADATA_TYPE) || nt.getName().equals(METADATA_TYPE)) continue;
            metadataTypes.add(nt);
        }
        return metadataTypes;
    }

    private Node createTemplateHome(Node nodetype, boolean isDialog) throws Exception {
        if (isDialog) {
            Node dialogs = null;
            dialogs = nodetype.hasNode(DIALOGS) ? nodetype.getNode(DIALOGS) : nodetype.addNode(DIALOGS, NT_UNSTRUCTURED);
            return dialogs;
        }
        Node views = null;
        views = nodetype.hasNode(VIEWS) ? nodetype.getNode(VIEWS) : nodetype.addNode(VIEWS, NT_UNSTRUCTURED);
        return views;
    }

    @Override
    public String getMetadataTemplate(String name, boolean isDialog, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node template = null;
        if (!this.hasMetadata(name, repository)) {
            return null;
        }
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        return this.templateService.getTemplate(template);
    }

    @Override
    public String getMetadataPath(String name, boolean isDialog, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        if (!this.hasMetadata(name, repository)) {
            return null;
        }
        Node template = null;
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        return template.getPath();
    }

    @Override
    public String getMetadataRoles(String name, boolean isDialog, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node template = null;
        if (!this.hasMetadata(name, repository)) {
            return null;
        }
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        return this.templateService.getTemplateRoles(template);
    }

    @Override
    public boolean hasMetadata(String name, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        return metadataHome.hasNode(name);
    }

    @Override
    public List<String> getExternalMetadataType(String repository) throws Exception {
        ArrayList<String> extenalMetaTypes = new ArrayList<String>();
        block0: for (NodeType metadata : this.getAllMetadatasNodeType(repository)) {
            for (PropertyDefinition pro : metadata.getPropertyDefinitions()) {
                if (!pro.getName().equals(INTERNAL_USE)) continue;
                if (pro.getDefaultValues()[0].getBoolean() || metadata.getName().equals(METADATA_TYPE)) continue block0;
                extenalMetaTypes.add(metadata.getName());
                continue block0;
            }
        }
        return extenalMetaTypes;
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        return sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
    }
}

