/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.model.XWPFHyperlinkDecorator;
import org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.xml.sax.SAXException;

public class XWPFWordExtractorDecorator
extends AbstractOOXMLExtractor {
    public XWPFWordExtractorDecorator(XWPFWordExtractor extractor) {
        super((POIXMLTextExtractor)extractor, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XWPFDocument document = (XWPFDocument)this.extractor.getDocument();
        XWPFHeaderFooterPolicy hfPolicy = document.getHeaderFooterPolicy();
        this.extractHeaders(xhtml, hfPolicy);
        Iterator i = document.getParagraphsIterator();
        while (i.hasNext()) {
            CTBookmark[] bookmarks;
            XWPFParagraph paragraph = (XWPFParagraph)i.next();
            CTSectPr ctSectPr = null;
            if (paragraph.getCTP().getPPr() != null) {
                ctSectPr = paragraph.getCTP().getPPr().getSectPr();
            }
            XWPFHeaderFooterPolicy headerFooterPolicy = null;
            if (ctSectPr != null) {
                headerFooterPolicy = new XWPFHeaderFooterPolicy(document, ctSectPr);
                this.extractHeaders(xhtml, headerFooterPolicy);
            }
            XWPFCommentsDecorator decorator = new XWPFCommentsDecorator((XWPFParagraphDecorator)new XWPFHyperlinkDecorator(paragraph, null, true));
            for (CTBookmark bookmark : bookmarks = paragraph.getCTP().getBookmarkStartArray()) {
                xhtml.element("p", bookmark.getName());
            }
            xhtml.element("p", decorator.getText());
            if (ctSectPr == null) continue;
            this.extractFooters(xhtml, headerFooterPolicy);
        }
        this.extractTableContent(document, xhtml);
        this.extractFooters(xhtml, hfPolicy);
    }

    private void extractFooters(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy) throws SAXException {
        if (hfPolicy.getFirstPageFooter() != null) {
            xhtml.element("p", hfPolicy.getFirstPageFooter().getText());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            xhtml.element("p", hfPolicy.getEvenPageFooter().getText());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            xhtml.element("p", hfPolicy.getDefaultFooter().getText());
        }
    }

    private void extractHeaders(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy) throws SAXException {
        if (hfPolicy.getFirstPageHeader() != null) {
            xhtml.element("p", hfPolicy.getFirstPageHeader().getText());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            xhtml.element("p", hfPolicy.getEvenPageHeader().getText());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            xhtml.element("p", hfPolicy.getDefaultHeader().getText());
        }
    }

    private void extractTableContent(XWPFDocument doc, XHTMLContentHandler xhtml) throws SAXException {
        for (CTTbl table : doc.getDocument().getBody().getTblArray()) {
            CTRow[] rows;
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            for (CTRow row : rows = table.getTrArray()) {
                CTTc[] cells;
                xhtml.startElement("tr");
                for (CTTc tc : cells = row.getTcArray()) {
                    CTP[] content;
                    xhtml.startElement("td");
                    for (CTP ctp : content = tc.getPArray()) {
                        MyXWPFParagraph p = new MyXWPFParagraph(ctp, doc);
                        XWPFCommentsDecorator decorator = new XWPFCommentsDecorator((XWPFParagraphDecorator)new XWPFHyperlinkDecorator((XWPFParagraph)p, null, true));
                        xhtml.element("p", decorator.getText());
                    }
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
        }
    }

    private static class MyXWPFParagraph
    extends XWPFParagraph {
        private MyXWPFParagraph(CTP ctp, XWPFDocument xwpfDocument) {
            super(ctp, xwpfDocument);
        }
    }
}

