/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.inmemory;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.storage.inmemory.InmemoryStorageConnection;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class InmemoryContainerImpl
extends WorkspaceDataContainerBase {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.InmemoryContainerImpl");
    private String name;

    public InmemoryContainerImpl(WorkspaceEntry wsEntry) throws RepositoryException {
        this.name = wsEntry.getUniqueName();
        log.debug((Object)("ContainerImpl() name: " + this.name));
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        String str = "Info: Inmemory (for testing only) based container \n";
        str = str + "Name: " + this.name + "\n";
        return str;
    }

    public WorkspaceStorageConnection openConnection() {
        return new InmemoryStorageConnection(this.name);
    }

    public WorkspaceStorageConnection reuseConnection(WorkspaceStorageConnection original) throws RepositoryException {
        return this.openConnection();
    }

    public String getStorageVersion() {
        return "1.0";
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        return new InmemoryStorageConnection(this.name);
    }

    public boolean isSame(WorkspaceDataContainer another) {
        return this.equals(another);
    }

    public boolean isCheckSNSNewConnection() {
        return true;
    }
}

