/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

public class StandardService
implements Lifecycle,
Service,
MBeanRegistration {
    private static Log log = LogFactory.getLog(StandardService.class);
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Server server = null;
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    protected ArrayList<Executor> executors = new ArrayList();
    protected Container container = null;
    protected boolean initialized = false;
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
        }
        Connector[] e = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].setContainer(this.container);
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (this.started && oldContainer != null && oldContainer instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldContainer)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("container", oldContainer, this.container);
            return;
        }
    }

    public ObjectName getContainerName() {
        if (this.container instanceof ContainerBase) {
            return ((ContainerBase)this.container).getJmxName();
        }
        return null;
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException e) {
                    log.error((Object)sm.getString("standardService.connector.initFailed", connector), (Throwable)e);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    connector.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", connector), (Throwable)e);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.connectors[i].getObjectName();
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int j = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (connector != this.connectors[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.started && this.connectors[j] instanceof Lifecycle) {
                try {
                    this.connectors[j].stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", this.connectors[j]), (Throwable)e);
                }
            }
            this.connectors[j].setContainer(null);
            connector.setService(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == j) continue;
                results[k++] = this.connectors[i];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(ex)) {
                this.executors.add(ex);
                if (this.started) {
                    try {
                        ex.start();
                    }
                    catch (LifecycleException x) {
                        log.error((Object)"Executor.start", (Throwable)x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] arr = new Executor[this.executors.size()];
            this.executors.toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor(String name) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (int i = 0; i < this.executors.size(); ++i) {
                if (!name.equals(this.executors.get(i).getName())) continue;
                return this.executors.get(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(ex) && this.started) {
                try {
                    ex.stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Executor.stop", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        int i;
        Connector[] connectorArray;
        if (this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("standardService.start.started"));
            }
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", this.name));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container != null) {
            connectorArray = this.container;
            synchronized (connectorArray) {
                if (this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).start();
                }
            }
        }
        connectorArray = this.executors;
        synchronized (connectorArray) {
            for (i = 0; i < this.executors.size(); ++i) {
                this.executors.get(i).start();
            }
        }
        connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (i = 0; i < this.connectors.length; ++i) {
                try {
                    this.connectors[i].start();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", this.connectors[i]), (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.lifecycle.fireLifecycleEvent("after_start", null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() throws LifecycleException {
        Object e3;
        int i;
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        Connector[] connectorArray = this.connectors;
        // MONITORENTER : this.connectors
        for (i = 0; i < this.connectors.length; ++i) {
            try {
                this.connectors[i].pause();
                continue;
            }
            catch (Exception e2) {
                log.error((Object)sm.getString("standardService.connector.pauseFailed", this.connectors[i]), (Throwable)e2);
            }
        }
        // MONITOREXIT : connectorArray
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e3) {
            // empty catch block
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.stop.name", this.name));
        }
        this.started = false;
        if (this.container != null) {
            e3 = this.container;
            // MONITORENTER : this.container
            if (this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).stop();
            }
            // MONITOREXIT : e3
        }
        e3 = this.connectors;
        // MONITORENTER : this.connectors
        for (i = 0; i < this.connectors.length; ++i) {
            try {
                this.connectors[i].stop();
                continue;
            }
            catch (Exception e4) {
                log.error((Object)sm.getString("standardService.connector.stopFailed", this.connectors[i]), (Throwable)e4);
            }
        }
        // MONITOREXIT : e3
        e3 = this.executors;
        // MONITORENTER : e3
        for (i = 0; i < this.executors.size(); ++i) {
            this.executors.get(i).stop();
        }
        // MONITOREXIT : e3
        if (this.oname == this.controller) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
            Executor[] executors = this.findExecutors();
            for (i = 0; i < executors.length; ++i) {
                try {
                    ObjectName executorObjectName = new ObjectName(this.domain + ":type=Executor,name=" + executors[i].getName());
                    Registry.getRegistry(null, null).unregisterComponent(executorObjectName);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("standardService.initialize.initialized"));
            }
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                Container engine = this.getContainer();
                this.domain = engine.getName();
                this.controller = this.oname = new ObjectName(this.domain + ":type=Service,serviceName=" + this.name);
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                Executor[] executors = this.findExecutors();
                for (int i = 0; i < executors.length; ++i) {
                    ObjectName executorObjectName = new ObjectName(this.domain + ":type=Executor,name=" + executors[i].getName());
                    Registry.getRegistry(null, null).registerComponent((Object)executors[i], executorObjectName, null);
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("standardService.register.failed", this.domain), (Throwable)e);
            }
        }
        if (this.server == null) {
            ServerFactory.getServer().addService(this);
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                try {
                    this.connectors[i].initialize();
                    continue;
                }
                catch (Exception e) {
                    String message = sm.getString("standardService.connector.initFailed", this.connectors[i]);
                    log.error((Object)message, (Throwable)e);
                    if (!Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) continue;
                    throw new LifecycleException(message);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void destroy() throws LifecycleException {
        if (this.started) {
            this.stop();
        }
    }

    public void init() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("standardService.initialize.failed", this.domain), t);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

