/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.workflow.webui.component.controller;

import java.util.ResourceBundle;
import javax.jcr.PathNotFoundException;
import org.exoplatform.services.workflow.Task;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.workflow.webui.component.UIUserSelectContainer;
import org.exoplatform.workflow.webui.component.controller.UITask;

@ComponentConfig(template="classpath:templates/controller/UITabPane.gtmpl", events={@EventConfig(listeners={ChangeTabActionListener.class})})
public class UITaskManager
extends UIContainer
implements UIPopupComponent {
    private String tokenId_;
    private boolean isStart_ = false;
    private String selectedTab;
    public static final String UIPOPUP_DELEGATEDSELECTOR_ID = "PopupDelegatedSelectorId";

    public UITaskManager() throws Exception {
        this.addChild(UITask.class, null, null);
    }

    public void initPopupSelectUser(String fieldName) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(UIPOPUP_DELEGATEDSELECTOR_ID);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, UIPOPUP_DELEGATEDSELECTOR_ID);
        } else {
            uiPopup.setRendered(true);
        }
        UIUserSelectContainer uiUserSelectContainer = (UIUserSelectContainer)this.createUIComponent(UIUserSelectContainer.class, null, null);
        uiUserSelectContainer.setFieldname(fieldName);
        uiPopup.setWindowSize(790, 400);
        uiPopup.setUIComponent((UIComponent)uiUserSelectContainer);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void setTokenId(String tokenId) {
        this.tokenId_ = tokenId;
    }

    public void setIsStart(boolean isStart) {
        this.isStart_ = isStart;
    }

    public void activate() throws Exception {
    }

    public boolean checkBeforeActive() throws Exception {
        WorkflowServiceContainer workflowServiceContainer = (WorkflowServiceContainer)this.getApplicationComponent(WorkflowServiceContainer.class);
        try {
            UITask uiTask = (UITask)this.getChild(UITask.class);
            uiTask.setIdentification(this.tokenId_);
            uiTask.setIsStart(this.isStart_);
            uiTask.updateUITree();
            return true;
        }
        catch (PathNotFoundException e) {
            Task task = workflowServiceContainer.getTask(this.tokenId_);
            String pid = task.getProcessInstanceId();
            workflowServiceContainer.deleteProcessInstance(pid);
            return false;
        }
    }

    public void deActivate() throws Exception {
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public String getClosingConfirmMsg(String key) {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTabActionListener
    extends EventListener<UITaskManager> {
        public void execute(Event<UITaskManager> event) throws Exception {
            UITaskManager uiTaskManager = (UITaskManager)((Object)event.getSource());
            uiTaskManager.setSelectedTab(event.getRequestContext().getRequestParameter("objectId"));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
        }
    }
}

