/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.DataFilter;
import dojox.cometd.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelImpl
implements Channel {
    protected AbstractBayeux _bayeux;
    private ClientImpl[] _subscribers = new ClientImpl[0];
    private DataFilter[] _dataFilters = new DataFilter[0];
    private ChannelId _id;
    private ConcurrentMap<String, ChannelImpl> _children = new ConcurrentHashMap<String, ChannelImpl>();
    private ChannelImpl _wild;
    private ChannelImpl _wildWild;
    private boolean _persistent;

    ChannelImpl(String id, AbstractBayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    public void addChild(ChannelImpl channel) {
        ChannelId child = channel.getChannelId();
        if (!this._id.isParentOf(child)) {
            throw new IllegalArgumentException(this._id + " not parent of " + child);
        }
        String next = child.getSegment(this._id.depth());
        if (child.depth() - this._id.depth() == 1) {
            ChannelImpl old = this._children.putIfAbsent(next, channel);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this._wild = channel;
            } else if ("**".equals(next)) {
                this._wildWild = channel;
            }
        } else {
            ChannelImpl branch = (ChannelImpl)this._children.get(next);
            branch = (ChannelImpl)this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
            branch.addChild(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.addToArray((Object[])this._dataFilters, (Object)filter, null);
        }
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public ChannelImpl getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        ChannelImpl channel = (ChannelImpl)this._children.get(next);
        if (channel == null || channel.getChannelId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }

    public void getChannels(List<Channel> list) {
        list.add(this);
        for (ChannelImpl channel : this._children.values()) {
            channel.getChannels(list);
        }
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void publish(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId);
    }

    public boolean remove() {
        return this._bayeux.removeChannel(this.getChannelId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFilter removeDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.removeFromArray((Object[])this._dataFilters, (Object)filter);
            return filter;
        }
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            for (ClientImpl c : this._subscribers) {
                if (!client.equals(c)) continue;
                return;
            }
            this._subscribers = (ClientImpl[])LazyList.addToArray((Object[])this._subscribers, (Object)client, null);
        }
        ((ClientImpl)client).addSubscription(this);
    }

    public String toString() {
        return this._id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ((ClientImpl)client).removeSubscription(this);
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._subscribers = (ClientImpl[])LazyList.removeFromArray((Object[])this._subscribers, (Object)client);
            if (!this._persistent && this._subscribers.length == 0 && this._children.size() == 0) {
                this.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doDelivery(ChannelId to, Client from, Message msg) {
        String next;
        ChannelImpl channel;
        ClientImpl[] subscribers;
        Object old;
        Object data;
        int tail;
        block31: {
            tail = to.depth() - this._id.depth();
            old = data = msg.getData();
            DataFilter[] filters = null;
            try {
                block13 : switch (tail) {
                    case 0: {
                        ChannelImpl channelImpl = this;
                        // MONITORENTER : channelImpl
                        filters = this._dataFilters;
                        // MONITOREXIT : channelImpl
                        for (DataFilter filter : filters) {
                            data = filter.filter(from, (Channel)this, data);
                        }
                        break block31;
                    }
                    case 1: {
                        DataFilter[] arr$;
                        if (this._wild != null) {
                            arr$ = this._wild;
                            // MONITORENTER : this._wild
                            filters = this._wild._dataFilters;
                            // MONITOREXIT : arr$
                            for (DataFilter filter : filters) {
                                data = filter.filter(from, (Channel)this, data);
                            }
                        }
                    }
                    default: {
                        if (this._wildWild == null) break block31;
                        DataFilter[] arr$ = this._wildWild;
                        // MONITORENTER : arr$
                        filters = this._wildWild._dataFilters;
                        // MONITOREXIT : arr$
                        arr$ = filters;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (i$ < len$) {
                            DataFilter filter;
                            filter = arr$[i$];
                            data = filter.filter(from, (Channel)this, data);
                            ++i$;
                            break block13;
                        }
                        break block31;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            catch (IllegalStateException e) {
                Log.debug((Throwable)e);
                return;
            }
        }
        if (data != old) {
            msg.put((Object)"data", data);
        }
        switch (tail) {
            case 0: {
                ChannelImpl len$ = this;
                // MONITORENTER : len$
                subscribers = this._subscribers;
                // MONITOREXIT : len$
                ClientImpl[] arr$ = subscribers;
                int len$2 = arr$.length;
                int i$ = 0;
                while (i$ < len$2) {
                    ClientImpl client = arr$[i$];
                    client.doDelivery(from, msg);
                    ++i$;
                }
                return;
            }
            case 1: {
                if (this._wild == null) break;
                ClientImpl[] arr$ = this._wild;
                // MONITORENTER : this._wild
                subscribers = this._wild._subscribers;
                // MONITOREXIT : arr$
                for (ClientImpl client : subscribers) {
                    client.doDelivery(from, msg);
                }
                break;
            }
        }
        if (this._wildWild != null) {
            ClientImpl[] arr$ = this._wildWild;
            // MONITORENTER : this._wildWild
            subscribers = this._wildWild._subscribers;
            // MONITOREXIT : arr$
            for (ClientImpl client : subscribers) {
                client.doDelivery(from, msg);
            }
        }
        if ((channel = (ChannelImpl)this._children.get(next = to.getSegment(this._id.depth()))) == null) return;
        channel.doDelivery(to, from, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Client> getSubscribers() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return Arrays.asList((Client[])this._subscribers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataFilter> getDataFilters() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return Arrays.asList(this._dataFilters);
        }
    }
}

