/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.wcm.webui.form.UIFormRichtextInput;
import org.exoplatform.wcm.webui.validator.FckMandatoryValidator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICommentForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_WEBSITE = "website";
    public static final String FIELD_COMMENT = "comment";
    private static final Log LOG = ExoLogger.getLogger(UICommentForm.class);
    private boolean edit;
    private String nodeCommentPath;
    private Node document_;

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public String getNodeCommentPath() {
        return this.nodeCommentPath;
    }

    public void setNodeCommentPath(String nodeCommentPath) {
        this.nodeCommentPath = nodeCommentPath;
    }

    private void prepareFields() throws Exception {
        Node comment;
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String userName = requestContext.getRemoteUser();
        if (userName == null || userName.length() == 0) {
            this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EMAIL, FIELD_EMAIL, null).addValidator(EmailAddressValidator.class, new Object[0]));
            this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_WEBSITE, FIELD_WEBSITE, null));
        }
        this.addUIFormInput((UIFormInput)new UIFormRichtextInput(FIELD_COMMENT, FIELD_COMMENT, "").addValidator(FckMandatoryValidator.class, new Object[0]));
        if (this.isEdit() && (comment = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getNodeByPath(this.nodeCommentPath, this.document_.getSession())).hasProperty("exo:commentContent")) {
            ((UIFormRichtextInput)this.getChild(UIFormRichtextInput.class)).setValue((Object)comment.getProperty("exo:commentContent").getString());
        }
    }

    public void activate() throws Exception {
        this.document_ = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        this.prepareFields();
    }

    public void deActivate() throws Exception {
        this.document_ = null;
    }

    public Node getDocument() {
        return this.document_;
    }

    public void setDocument(Node doc) {
        this.document_ = doc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UICommentForm> {
        public void execute(Event<UICommentForm> event) throws Exception {
            UICommentForm uiForm = (UICommentForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            String comment = (String)((UIFormRichtextInput)uiForm.getChild(UIFormRichtextInput.class)).getValue();
            CommentsService commentsService = (CommentsService)uiForm.getApplicationComponent(CommentsService.class);
            if (comment == null || comment.trim().length() == 0) {
                throw new MessageException(new ApplicationMessage("UICommentForm.msg.content-null", null, 1));
            }
            if (uiForm.isEdit()) {
                try {
                    Node commentNode = uiExplorer.getNodeByPath(uiForm.getNodeCommentPath(), uiForm.document_.getSession());
                    commentsService.updateComment(commentNode, comment);
                }
                catch (Exception e) {}
            } else {
                String userName = event.getRequestContext().getRemoteUser();
                String website = null;
                String email = null;
                if (userName == null || userName.length() == 0) {
                    userName = "anonymous";
                    website = (String)uiForm.getUIStringInput(UICommentForm.FIELD_WEBSITE).getValue();
                    email = (String)uiForm.getUIStringInput(UICommentForm.FIELD_EMAIL).getValue();
                } else {
                    OrganizationService organizationService = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
                    UserProfileHandler profileHandler = organizationService.getUserProfileHandler();
                    UserHandler userHandler = organizationService.getUserHandler();
                    User user = userHandler.findUserByName(userName);
                    UserProfile userProfile = profileHandler.findUserProfileByName(userName);
                    website = (String)userProfile.getUserInfoMap().get("user.business-info.online.uri");
                    email = user.getEmail();
                }
                try {
                    String language = ((UIDocumentInfo)((UIDocumentContainer)((UIDocumentWorkspace)((UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class)).getChild(UIDocumentWorkspace.class)).getChild(UIDocumentContainer.class)).getChild(UIDocumentInfo.class)).getLanguage();
                    commentsService.addComment(uiForm.document_, userName, email, website, comment, language);
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiExplorer.getChildById("ViewSearch");
            if (uiPopup != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            }
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UICommentForm> {
        public void execute(Event<UICommentForm> event) throws Exception {
            ((UIPopupContainer)((UICommentForm)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class)).cancelPopupAction();
        }
    }
}

