/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jgroups.Message;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public class AckSenderWindowTest
extends TestCase {
    private AckSenderWindow win;
    long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    protected TimeScheduler timer = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.timer = new TimeScheduler(10);
        this.win = new AckSenderWindow(null, new StaticInterval(this.xmit_timeouts), this.timer);
    }

    protected void tearDown() throws Exception {
        this.timer.stop();
        this.win.reset();
        super.tearDown();
    }

    public void testLowest() {
        for (long i = 1L; i < 5L; ++i) {
            this.win.add(i, new Message());
        }
        System.out.println("win = " + this.win + ", lowest=" + this.win.getLowest());
        AckSenderWindowTest.assertEquals((long)1L, (long)this.win.getLowest());
        this.win.ack(3L);
        System.out.println("win = " + this.win + ", lowest=" + this.win.getLowest());
        AckSenderWindowTest.assertEquals((long)4L, (long)this.win.getLowest());
        this.win.ack(4L);
        System.out.println("win = " + this.win + ", lowest=" + this.win.getLowest());
        AckSenderWindowTest.assertEquals((long)5L, (long)this.win.getLowest());
        this.win.ack(2L);
        AckSenderWindowTest.assertEquals((long)5L, (long)this.win.getLowest());
    }

    public void testGetLowestMessage() {
        long[] seqnos = new long[]{1L, 2L, 3L, 4L, 5L};
        Message[] msgs = new Message[]{new Message(), new Message(), new Message(), new Message(), new Message()};
        for (int i = 0; i < seqnos.length; ++i) {
            this.win.add(seqnos[i], msgs[i]);
        }
        System.out.println("win = " + this.win);
        Message msg = this.win.getLowestMessage();
        AckSenderWindowTest.assertSame((Object)msg, (Object)msgs[0]);
        this.win.ack(2L);
        msg = this.win.getLowestMessage();
        AckSenderWindowTest.assertSame((Object)msg, (Object)msgs[2]);
        this.win.ack(7L);
        msg = this.win.getLowestMessage();
        AckSenderWindowTest.assertNull((Object)msg);
    }

    public void testAdd() {
        for (int i = 1; i <= 10; ++i) {
            this.win.add(i, new Message());
        }
        System.out.println("win = " + this.win);
        AckSenderWindowTest.assertEquals((int)10, (int)this.win.size());
        this.win.ack(7L);
        AckSenderWindowTest.assertEquals((int)3, (int)this.win.size());
    }

    public void testAck() {
        for (int i = 1; i <= 3; ++i) {
            this.win.add(i, new Message());
        }
        AckSenderWindowTest.assertEquals((int)3, (int)this.win.size());
        this.win.ack(1L);
        AckSenderWindowTest.assertEquals((int)2, (int)this.win.size());
        this.win.ack(2L);
        AckSenderWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.ack(3L);
        AckSenderWindowTest.assertEquals((int)0, (int)this.win.size());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(AckSenderWindowTest.class);
        return suite;
    }
}

