/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class NavigationCleanupFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(NavigationCleanupFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        PortalContainer container = PortalContainer.getInstance();
        WebAppController controller = (WebAppController)container.getComponentInstance(WebAppController.class);
        PortalApplication app = (PortalApplication)controller.getApplication("PortalApplication");
        String url = req.getParameter("url");
        String portalSite = req.getParameter("portal");
        try {
            RequestLifeCycle.begin((ExoContainer)container);
            ExtendedPortalRequestContext context = new ExtendedPortalRequestContext((WebuiApplication)app, req, res);
            context.setPortalName(portalSite);
            UIApplication uiApp = app.getStateManager().restoreUIRootComponent((WebuiRequestContext)context);
            UIPortalApplication pApp = (UIPortalApplication)uiApp;
            String remoteUser = context.getRemoteUser();
            UserPortalConfigService service_ = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
            pApp.setUserPortalConfig(service_.getUserPortalConfig(portalSite, remoteUser));
        }
        catch (Exception e) {
        }
        finally {
            res.sendRedirect(url);
            RequestLifeCycle.end();
        }
    }

    class ExtendedPortalRequestContext
    extends PortalRequestContext {
        private String portalName;

        public ExtendedPortalRequestContext(WebuiApplication app, HttpServletRequest req, HttpServletResponse res) throws Exception {
            super(app, req, res);
        }

        public void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        public String getPortalOwner() {
            return this.portalName;
        }
    }
}

