/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.RoleType;

public class MembershipTypeDAOImpl
implements MembershipTypeHandler {
    public static final String MEMBERSHIP_DESCRIPTION = "description";
    public static final String MEMBERSHIP_OWNER = "owner";
    public static final String MEMBERSHIP_CREATE_DATE = "create_date";
    public static final String MEMBERSHIP_MODIFIED_DATE = "modified_date";
    public static final DateFormat dateFormat = DateFormat.getInstance();
    private PicketLinkIDMService service_;
    private PicketLinkIDMOrganizationServiceImpl orgService;
    private static Logger log = LoggerFactory.getLogger(MembershipTypeDAOImpl.class);

    public MembershipTypeDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        this.service_ = service;
        this.orgService = orgService;
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "createMembershipType", new Object[]{"membershipType", mt, "broadcast", broadcast});
        }
        Date now = new Date();
        mt.setCreatedDate(now);
        mt.setModifiedDate(now);
        this.getIdentitySession().getRoleManager().createRoleType(mt.getName());
        this.updateMembershipType(mt);
        return mt;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "saveMembershipType", new Object[]{"membershipType", mt, "broadcast", broadcast});
        }
        Date now = new Date();
        mt.setModifiedDate(now);
        this.updateMembershipType(mt);
        return mt;
    }

    public MembershipType findMembershipType(String name) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findMembershipType", new Object[]{"name", name});
        }
        RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(name);
        MembershipTypeImpl mt = null;
        if (rt != null) {
            mt = new MembershipTypeImpl(name, null, null);
            this.populateMembershipType((MembershipType)mt);
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findMembershipType", mt);
        }
        return mt;
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        MembershipType mt;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "removeMembershipType", new Object[]{"name", name, "broadcast", broadcast});
        }
        if ((mt = this.findMembershipType(name)) != null) {
            this.getIdentitySession().getRoleManager().removeRoleType(mt.getName());
        }
        return mt;
    }

    public Collection findMembershipTypes() throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findMembershipTypes", null);
        }
        Collection rts = this.getIdentitySession().getRoleManager().findRoleTypes();
        LinkedList<MembershipTypeImpl> mts = new LinkedList<MembershipTypeImpl>();
        for (RoleType rt : rts) {
            MembershipTypeImpl mt = new MembershipTypeImpl(rt.getName(), null, null);
            this.populateMembershipType((MembershipType)mt);
            mts.add(mt);
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findMembershipTypes", mts);
        }
        return mts;
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private void updateMembershipType(MembershipType mt) throws Exception {
        RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(mt.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(MEMBERSHIP_DESCRIPTION, mt.getDescription());
        props.put(MEMBERSHIP_CREATE_DATE, mt.getCreatedDate() == null ? null : "" + mt.getCreatedDate().getTime());
        props.put(MEMBERSHIP_MODIFIED_DATE, mt.getModifiedDate() == null ? null : "" + mt.getModifiedDate().getTime());
        props.put(MEMBERSHIP_OWNER, mt.getOwner());
        this.getIdentitySession().getRoleManager().setProperties(rt, props);
    }

    private void populateMembershipType(MembershipType mt) throws Exception {
        long date;
        RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(mt.getName());
        Map props = this.getIdentitySession().getRoleManager().getProperties(rt);
        mt.setDescription((String)props.get(MEMBERSHIP_DESCRIPTION));
        mt.setOwner((String)props.get(MEMBERSHIP_OWNER));
        String cd = (String)props.get(MEMBERSHIP_CREATE_DATE);
        String md = (String)props.get(MEMBERSHIP_MODIFIED_DATE);
        if (cd != null) {
            try {
                date = Long.parseLong(cd);
                mt.setCreatedDate(new Date(date));
            }
            catch (NumberFormatException e) {
                try {
                    mt.setCreatedDate(dateFormat.parse(cd));
                }
                catch (ParseException e2) {
                    log.error((Object)("Cannot parse the membership type creation date for: " + mt.getName()));
                }
            }
        }
        if (md != null) {
            try {
                date = Long.parseLong(md);
                mt.setModifiedDate(new Date(date));
            }
            catch (NumberFormatException e) {
                try {
                    mt.setModifiedDate(dateFormat.parse(md));
                }
                catch (ParseException e2) {
                    log.error((Object)("Cannot parse the membership type modification date for: " + mt.getName()));
                }
            }
        }
    }
}

