/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FilenameUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;

@Path(value="/fileexchange")
public class FileExchangeService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)FileExchangeService.class.getName());
    private String tmpDir = null;

    public FileExchangeService(InitParams initParams) {
        if (initParams != null && initParams.getValueParam("tmpdir") != null) {
            this.tmpDir = initParams.getValueParam("tmpdir").getValue();
        }
        if (this.tmpDir == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Tmp dir is not set, default " + System.getProperty("java.io.tmpdir")));
            }
            this.tmpDir = System.getProperty("java.io.tmpdir");
        }
    }

    @POST
    public Response upload() throws IOException {
        EnvironmentContext env = EnvironmentContext.getCurrent();
        HttpServletRequest req = (HttpServletRequest)env.get(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)env.get(HttpServletResponse.class);
        String description = req.getParameter("description");
        String username = req.getParameter("username");
        String requestor = req.getParameter("requestor");
        String isRoom = req.getParameter("isroom");
        boolean isMultipart = FileUploadBase.isMultipartContent((HttpServletRequest)req);
        if (isMultipart) {
            DiskFileUpload upload = new DiskFileUpload();
            try {
                List items = upload.parseRequest(req);
                XMPPMessenger messenger = (XMPPMessenger)PortalContainer.getInstance().getComponentInstanceOfType(XMPPMessenger.class);
                for (FileItem fileItem : items) {
                    XMPPSessionImpl session = (XMPPSessionImpl)messenger.getSession(username);
                    String fileName = fileItem.getName();
                    String fileType = fileItem.getContentType();
                    if (session != null) {
                        if (fileName == null) continue;
                        fileName = FilenameUtils.getName((String)fileName);
                        fileType = FilenameUtils.getExtension((String)fileName);
                        File file = new File(this.tmpDir);
                        if (!file.isDirectory()) continue;
                        String uuid = UUID.randomUUID().toString();
                        boolean success = new File(this.tmpDir + "/" + uuid).mkdir();
                        if (success) {
                            int len;
                            String path = this.tmpDir + "/" + uuid + "/" + fileName;
                            File f = new File(path);
                            success = f.createNewFile();
                            if (!success) continue;
                            InputStream inputStream = fileItem.getInputStream();
                            FileOutputStream out = new FileOutputStream(f);
                            byte[] buf = new byte[1024];
                            while ((len = inputStream.read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((OutputStream)out).close();
                            inputStream.close();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("File " + path + "is created"));
                            }
                            session.sendFile(requestor, path, description, Boolean.parseBoolean(isRoom));
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)"File already exists");
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("XMPPSession for user " + username + " is null!"));
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return Response.status((int)400).entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok().build();
    }
}

