/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.capture.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Utils {
    public static String productNameAndVersion = "";
    public static String pingServerURL = "";
    public static String relativeFilePath = "../conf/";
    public static String registrationFormUrl;
    public static final int DEFAULT_DELAY_PERIOD = 30;
    public static int delayPeriod;
    public static String KEY_CONTENT;
    public static boolean outdated;
    public static final String LEAD_CAPTURE_KEY = "UnlockKey";
    public static final String REMIND_DATE = "remindDate";
    public static final String LAST_START_DATE = "LSTD";
    public static final String USER_HOME;
    public static final String EXO_HOME_FOLDER;
    public static final String CONFIG_FILE_LOCATION;
    private static final DateFormat dateFormat;

    public static String getModifiedMD5Code(byte[] dataToHash) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Provider provBC = Security.getProvider("BC");
        MessageDigest digest = MessageDigest.getInstance("MD5", provBC);
        digest.update(dataToHash);
        byte[] hashMD5 = digest.digest(dataToHash);
        StringBuffer hashMD5String = new StringBuffer();
        for (int i = 0; i < hashMD5.length; ++i) {
            int n = i;
            hashMD5[n] = (byte)(hashMD5[n] % 26);
            hashMD5[i] = (byte)Math.abs(hashMD5[i]);
            int n2 = i;
            hashMD5[n2] = (byte)(hashMD5[n2] + 64);
            hashMD5String.append((char)hashMD5[i]);
        }
        return hashMD5String.toString();
    }

    public static String formatDate(Calendar date) {
        return dateFormat.format(date.getTime());
    }

    public static Calendar parseDate(String dateString) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(dateString));
        return calendar;
    }

    public static void writeHashCode(String hashMD5) {
        try {
            FileOutputStream outputStream;
            Properties properties = new Properties();
            if (new File(CONFIG_FILE_LOCATION).exists()) {
                FileInputStream inputStream = new FileInputStream(CONFIG_FILE_LOCATION);
                properties.loadFromXML(inputStream);
                ((InputStream)inputStream).close();
            } else {
                if (!new File(EXO_HOME_FOLDER).exists()) {
                    new File(EXO_HOME_FOLDER).mkdirs();
                }
                properties.put(LEAD_CAPTURE_KEY, "");
                outputStream = new FileOutputStream(CONFIG_FILE_LOCATION);
                properties.storeToXML(outputStream, CONFIG_FILE_LOCATION);
            }
            properties.put(LEAD_CAPTURE_KEY, hashMD5);
            outputStream = new FileOutputStream(CONFIG_FILE_LOCATION);
            properties.storeToXML(outputStream, CONFIG_FILE_LOCATION);
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeRemindDate(String remindDateStringBase64) {
        try {
            FileOutputStream outputStream;
            Properties properties = new Properties();
            if (new File(CONFIG_FILE_LOCATION).exists()) {
                FileInputStream inputStream = new FileInputStream(CONFIG_FILE_LOCATION);
                properties.loadFromXML(inputStream);
                ((InputStream)inputStream).close();
            } else {
                if (!new File(EXO_HOME_FOLDER).exists()) {
                    new File(EXO_HOME_FOLDER).mkdirs();
                }
                properties.put(LEAD_CAPTURE_KEY, "");
                outputStream = new FileOutputStream(CONFIG_FILE_LOCATION);
                properties.storeToXML(outputStream, CONFIG_FILE_LOCATION);
            }
            properties.put(REMIND_DATE, remindDateStringBase64);
            outputStream = new FileOutputStream(CONFIG_FILE_LOCATION);
            properties.storeToXML(outputStream, CONFIG_FILE_LOCATION);
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String formatDateBase64(Calendar date) {
        return new String(Base64.encodeBase64((byte[])Utils.formatDate(date).getBytes()));
    }

    public static Calendar parseDateBase64(String dateString) throws ParseException {
        return Utils.parseDate(new String(Base64.decodeBase64((byte[])dateString.getBytes())));
    }

    public static String computeRemindDateFromTodayBase64() {
        if (delayPeriod <= 0 || outdated) {
            return "";
        }
        Calendar remindDate = Calendar.getInstance();
        remindDate.add(5, delayPeriod);
        return Utils.formatDateBase64(remindDate);
    }

    static {
        delayPeriod = 30;
        outdated = false;
        USER_HOME = System.getProperty("user.home");
        EXO_HOME_FOLDER = USER_HOME + "/.eXo";
        CONFIG_FILE_LOCATION = EXO_HOME_FOLDER + "/exokey.xml";
        dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    }
}

