/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.filter.FilterMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDefinition {
    private Filter filter;
    private volatile FilterMapping mapping;
    private List<String> patterns;

    public FilterDefinition() {
    }

    public FilterDefinition(Filter filter, List<String> patterns) {
        this.filter = filter;
        this.patterns = patterns;
    }

    public Filter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterMapping getMapping() {
        if (this.mapping == null) {
            FilterDefinition filterDefinition = this;
            synchronized (filterDefinition) {
                if (this.mapping == null) {
                    this.mapping = new PatternMapping(this.patterns);
                    this.patterns = null;
                }
            }
        }
        return this.mapping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternMapping
    implements FilterMapping {
        private final List<Pattern> patterns;

        private PatternMapping(List<String> strPatterns) {
            if (strPatterns == null || strPatterns.isEmpty()) {
                throw new IllegalArgumentException("The list of patterns cannot be empty");
            }
            this.patterns = new ArrayList<Pattern>(strPatterns.size());
            for (String sPattern : strPatterns) {
                this.patterns.add(Pattern.compile(sPattern));
            }
        }

        @Override
        public boolean match(String path) {
            int length = this.patterns.size();
            for (int i = 0; i < length; ++i) {
                Pattern pattern = this.patterns.get(i);
                Matcher matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
    }
}

