/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="system:/groovy/webui/core/UIGrid.gtmpl")
public class UIEditingTagList
extends UIGrid {
    private static String[] BEAN_FIELD = new String[]{"name"};
    private static String[] ACTIONS = new String[]{"EditTag", "RemoveTag"};
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    public static final String EXO_TOTAL = "exo:total";

    public UIEditingTagList() throws Exception {
        this.getUIPageIterator().setId("TagIterator");
        this.configure("name", BEAN_FIELD, ACTIONS);
    }

    public void updateGrid() throws Exception {
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiExplorer.getApplicationComponent(NodeHierarchyCreator.class);
        String repository = uiExplorer.getRepositoryName();
        String workspace = uiExplorer.getRepository().getConfiguration().getDefaultWorkspaceName();
        int scope = uiExplorer.getTagScope();
        String publicTagNodePath = nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
        List tags = scope == 1 ? newFolksonomyService.getAllPrivateTags(uiExplorer.getSession().getUserID(), repository, workspace) : newFolksonomyService.getAllPublicTags(publicTagNodePath, repository, workspace);
        ArrayList<TagData> tagDataList = new ArrayList<TagData>();
        for (Node tag : tags) {
            tagDataList.add(new TagData(tag.getName()));
        }
        ObjectPageList objPageList = new ObjectPageList(tagDataList, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public static class TagData {
        private String tagName;

        public TagData(String tagName) {
            this.tagName = tagName;
        }

        public String getName() {
            return this.tagName;
        }
    }
}

