/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.EmptyTermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingleTermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.TermDocsCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingIndexReader
extends FilterIndexReader {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.CachingIndexReader");
    private static long currentTick;
    private final BitSet shareableNodes;
    private final DocId[] parents;
    private CacheInitializer cacheInitializer;
    private final long creationTick = CachingIndexReader.getNextCreationTick();
    private final DocNumberCache cache;
    private final Map<Integer, String> docNumber2uuid;
    private final TermDocsCache termDocsCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachingIndexReader(IndexReader delegatee, DocNumberCache cache, boolean initCache) throws IOException {
        super(delegatee);
        this.cache = cache;
        this.parents = new DocId[delegatee.maxDoc()];
        this.shareableNodes = new BitSet();
        TermDocs tDocs = delegatee.termDocs(new Term(FieldNames.SHAREABLE_NODE, ""));
        try {
            while (tDocs.next()) {
                this.shareableNodes.set(tDocs.doc());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            tDocs.close();
            throw throwable;
        }
        tDocs.close();
        this.cacheInitializer = new CacheInitializer(delegatee);
        if (initCache) {
            this.cacheInitializer.run();
        }
        this.docNumber2uuid = Collections.synchronizedMap(new LRUMap(Math.max(10, delegatee.maxDoc() / 100)));
        this.termDocsCache = new TermDocsCache(delegatee, FieldNames.PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocId getParent(int n, BitSet deleted) throws IOException {
        boolean existing = false;
        DocId parent = this.parents[n];
        if (parent != null) {
            existing = true;
            if (!parent.isValid(deleted)) {
                if (log.isDebugEnabled()) {
                    log.debug(parent + " not valid anymore.");
                }
                parent = null;
            }
        }
        if (parent == null) {
            Document doc = this.document(n, FieldSelectors.UUID_AND_PARENT);
            String[] parentUUIDs = doc.getValues(FieldNames.PARENT);
            if (parentUUIDs.length == 0 || parentUUIDs[0].length() == 0) {
                parent = DocId.NULL;
            } else if (this.shareableNodes.get(n)) {
                parent = DocId.create(parentUUIDs);
            } else {
                if (!existing) {
                    Term id = new Term(FieldNames.UUID, parentUUIDs[0]);
                    TermDocs docs = this.termDocs(id);
                    try {
                        while (docs.next()) {
                            if (deleted.get(docs.doc())) continue;
                            parent = DocId.create(docs.doc());
                            break;
                        }
                        Object var10_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        docs.close();
                        throw throwable;
                    }
                    docs.close();
                    {
                    }
                }
                if (parent == null) {
                    parent = DocId.create(parentUUIDs[0]);
                }
            }
            this.parents[n] = parent;
        }
        return parent;
    }

    public long getCreationTick() {
        return this.creationTick;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        if (fieldSelector == FieldSelectors.UUID) {
            Document doc;
            Integer docNum = new Integer(n);
            String uuid = this.docNumber2uuid.get(docNum);
            if (uuid == null) {
                doc = super.document(n, fieldSelector);
                uuid = doc.get(FieldNames.UUID);
                this.docNumber2uuid.put(docNum, uuid);
            } else {
                doc = new Document();
                doc.add((Fieldable)new Field(FieldNames.UUID, uuid.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            return doc;
        }
        return super.document(n, fieldSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term.field() == FieldNames.UUID && this.cache != null) {
            TermDocs docs;
            block5: {
                SingleTermDocs singleTermDocs;
                DocNumberCache.Entry e = this.cache.get(term.text());
                if (e != null && e.creationTick == this.creationTick && !this.isDeleted(e.doc)) {
                    return new SingleTermDocs(e.doc);
                }
                docs = this.in.termDocs(term);
                try {
                    if (!docs.next()) break block5;
                    this.cache.put(term.text(), this, docs.doc());
                    singleTermDocs = new SingleTermDocs(docs.doc());
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    docs.close();
                    throw throwable;
                }
                docs.close();
                return singleTermDocs;
            }
            TermDocs termDocs = EmptyTermDocs.INSTANCE;
            Object var6_7 = null;
            docs.close();
            return termDocs;
        }
        return this.termDocsCache.termDocs(term);
    }

    protected void doClose() throws IOException {
        try {
            this.cacheInitializer.waitUntilStopped();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCreationTick() {
        Class<CachingIndexReader> clazz = CachingIndexReader.class;
        synchronized (CachingIndexReader.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentTick++;
        }
    }

    private static final class NodeInfo {
        final int docId;
        final String uuid;
        String parent;

        public NodeInfo(int docId, String uuid) {
            this.docId = docId;
            this.uuid = uuid;
        }
    }

    private static interface TermDocsCollector {
        public void collect(Term var1, TermDocs var2) throws IOException;
    }

    private class CacheInitializer
    implements Runnable {
        private final IndexReader reader;
        private boolean running = false;
        private volatile boolean stopRequested = false;

        public CacheInitializer(IndexReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block15: {
                CacheInitializer cacheInitializer;
                block14: {
                    CacheInitializer cacheInitializer2 = this;
                    synchronized (cacheInitializer2) {
                        this.running = true;
                    }
                    try {
                        try {
                            if (this.stopRequested) {
                                Object var4_3 = null;
                                cacheInitializer = this;
                                break block14;
                            }
                            this.initializeParents(this.reader);
                            break block15;
                        }
                        catch (Exception e) {
                            if (!this.stopRequested) {
                                log.warn("Error initializing parents cache.", (Throwable)e);
                            }
                            Object var4_5 = null;
                            CacheInitializer cacheInitializer3 = this;
                            synchronized (cacheInitializer3) {
                                this.running = false;
                                this.notifyAll();
                                return;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        CacheInitializer cacheInitializer4 = this;
                        synchronized (cacheInitializer4) {
                            this.running = false;
                            this.notifyAll();
                            throw throwable;
                        }
                    }
                }
                synchronized (cacheInitializer) {
                    this.running = false;
                    this.notifyAll();
                    return;
                }
            }
            Object var4_4 = null;
            CacheInitializer cacheInitializer = this;
            synchronized (cacheInitializer) {
                this.running = false;
                this.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilStopped() throws InterruptedException {
            this.stopRequested = true;
            CacheInitializer cacheInitializer = this;
            synchronized (cacheInitializer) {
                while (this.running) {
                    this.wait();
                }
            }
        }

        private void initializeParents(IndexReader reader) throws IOException {
            long time = System.currentTimeMillis();
            final HashMap docs = new HashMap();
            this.collectTermDocs(reader, new Term(FieldNames.UUID, ""), new TermDocsCollector(){

                public void collect(Term term, TermDocs tDocs) throws IOException {
                    String uuid = term.text();
                    while (tDocs.next()) {
                        int doc = tDocs.doc();
                        if (CachingIndexReader.this.shareableNodes.get(doc)) continue;
                        NodeInfo info = new NodeInfo(doc, uuid);
                        docs.put(new Integer(doc), info);
                    }
                }
            });
            this.collectTermDocs(reader, new Term(FieldNames.PARENT, "0"), new TermDocsCollector(){

                public void collect(Term term, TermDocs tDocs) throws IOException {
                    String uuid = term.text();
                    while (tDocs.next()) {
                        Integer docId = new Integer(tDocs.doc());
                        NodeInfo info = (NodeInfo)docs.get(docId);
                        if (info == null) continue;
                        info.parent = uuid;
                        docs.remove(docId);
                        docs.put(info.uuid, info);
                    }
                }
            });
            if (this.stopRequested) {
                return;
            }
            double foreignParents = 0.0;
            for (NodeInfo info : docs.values()) {
                NodeInfo parent = (NodeInfo)docs.get(info.parent);
                if (parent != null) {
                    ((CachingIndexReader)CachingIndexReader.this).parents[info.docId] = DocId.create(parent.docId);
                    continue;
                }
                if (info.parent != null) {
                    foreignParents += 1.0;
                    ((CachingIndexReader)CachingIndexReader.this).parents[info.docId] = DocId.create(info.parent);
                    continue;
                }
                if (CachingIndexReader.this.shareableNodes.get(info.docId)) {
                    Document doc = reader.document(info.docId, FieldSelectors.UUID_AND_PARENT);
                    ((CachingIndexReader)CachingIndexReader.this).parents[info.docId] = DocId.create(doc.getValues(FieldNames.PARENT));
                    continue;
                }
                ((CachingIndexReader)CachingIndexReader.this).parents[info.docId] = DocId.NULL;
            }
            if (log.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getPercentInstance();
                nf.setMaximumFractionDigits(1);
                time = System.currentTimeMillis() - time;
                if (CachingIndexReader.this.parents.length > 0) {
                    foreignParents /= (double)CachingIndexReader.this.parents.length;
                }
                log.debug("initialized {} DocIds in {} ms, {} foreign parents", new Object[]{new Integer(CachingIndexReader.this.parents.length), new Long(time), nf.format(foreignParents)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectTermDocs(IndexReader reader, Term start, TermDocsCollector collector) throws IOException {
            TermDocs tDocs = reader.termDocs();
            try {
                TermEnum terms = reader.terms(start);
                try {
                    Term t;
                    int count = 0;
                    while ((t = terms.term()) != null && t.field() == start.field()) {
                        tDocs.seek(terms);
                        collector.collect(t, tDocs);
                        if (++count % 10000 == 0 && this.stopRequested) break;
                        if (terms.next()) continue;
                        break;
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    terms.close();
                    throw throwable;
                }
                terms.close();
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                tDocs.close();
                throw throwable;
            }
            tDocs.close();
        }
    }
}

