/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/drives/UINodeTypeSelector.gtmpl", events={@EventConfig(listeners={SearchNodeTypeActionListener.class}), @EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectedAllNodeTypesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UINodeTypeSelector
extends org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSelector
implements ComponentSelector {
    private static final String ALL_DOCUMENT_TYPES = "ALL_DOCUMENT_TYPES";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiNodeTypeSelector.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            UIComponent component = uiNodeTypeSelector.getSourceComponent().getParent();
            if (component != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPageActionListener
    extends EventListener<UIPageIterator> {
        public void execute(Event<UIPageIterator> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((UIPageIterator)event.getSource()).getAncestorOfType(UINodeTypeSelector.class);
            List selectedNodetypes = uiNodeTypeSelector.getSelectedNodetypes();
            ArrayList listCheckbox = new ArrayList();
            uiNodeTypeSelector.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (UIFormCheckBoxInput uiCheckBox : listCheckbox) {
                if (selectedNodetypes.contains(uiCheckBox.getValue().toString())) {
                    uiCheckBox.setChecked(true);
                    continue;
                }
                uiCheckBox.setChecked(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectedAllNodeTypesActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            String returnField = uiNodeTypeSelector.getReturnFieldName();
            String value = "*";
            ((UISelectable)uiNodeTypeSelector.getSourceComponent()).doSelect(returnField, (Object)value);
            UIPopupWindow uiPopup = (UIPopupWindow)uiNodeTypeSelector.getParent();
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiNodeTypeSelector.getSourceComponent().getParent());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            ArrayList listCheckbox = new ArrayList();
            uiNodeTypeSelector.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (int i = 0; i < listCheckbox.size(); ++i) {
                ((UIFormCheckBoxInput)listCheckbox.get(i)).setChecked(false);
                uiNodeTypeSelector.getSelectedNodetypes().clear();
            }
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            String returnField = uiNodeTypeSelector.getReturnFieldName();
            List selectedNodetypes = uiNodeTypeSelector.getSelectedNodetypes();
            if (selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES)) {
                selectedNodetypes.remove(UINodeTypeSelector.ALL_DOCUMENT_TYPES);
                for (String docNodeType : uiNodeTypeSelector.getDocumentNodetypes()) {
                    if (selectedNodetypes.contains(docNodeType) || !((UIFormCheckBoxInput)uiNodeTypeSelector.findComponentById(docNodeType)).isChecked()) continue;
                    selectedNodetypes.add(docNodeType);
                }
            }
            String nodeTypeString = "";
            int index = 0;
            for (String strNodeType : selectedNodetypes) {
                nodeTypeString = index == 0 ? nodeTypeString + strNodeType : nodeTypeString + "," + strNodeType;
                ++index;
            }
            ((UISelectable)uiNodeTypeSelector.getSourceComponent()).doSelect(returnField, (Object)nodeTypeString);
            selectedNodetypes.clear();
            UIPopupWindow uiPopup = (UIPopupWindow)uiNodeTypeSelector.getParent();
            uiPopup.setShow(false);
            UIComponent component = uiNodeTypeSelector.getSourceComponent().getParent();
            if (component != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnChangeActionListener
    extends EventListener<UINodeTypeSelector> {
        private void updateCheckBox(List<String> selectedNodetypes, UIFormCheckBoxInput uiCheckBox) {
            if (uiCheckBox.isChecked()) {
                if (!selectedNodetypes.contains(uiCheckBox.getValue().toString())) {
                    selectedNodetypes.add(uiCheckBox.getValue().toString());
                }
            } else {
                selectedNodetypes.remove(uiCheckBox.getValue().toString());
            }
        }

        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)((Object)event.getSource());
            List selectedNodetypes = uiNodeTypeSelect.getSelectedNodetypes();
            ArrayList preSelectedNodetypes = new ArrayList();
            preSelectedNodetypes.addAll(selectedNodetypes);
            List lstNodeType = uiNodeTypeSelect.getNodeTypeList();
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(UINodeTypeSelector.ALL_DOCUMENT_TYPES);
            this.updateCheckBox(selectedNodetypes, uiCheckBox);
            for (NodeType nodetype : lstNodeType) {
                uiCheckBox = (UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(nodetype.getName());
                this.updateCheckBox(selectedNodetypes, uiCheckBox);
            }
            if (selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && !preSelectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES)) {
                for (String nodeTypeName : uiNodeTypeSelect.getDocumentNodetypes()) {
                    ((UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(nodeTypeName)).setChecked(true);
                    if (selectedNodetypes.contains(nodeTypeName)) continue;
                    selectedNodetypes.add(nodeTypeName);
                }
            } else if (!selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && preSelectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && selectedNodetypes.containsAll(uiNodeTypeSelect.getDocumentNodetypes())) {
                for (String nodeTypeName : uiNodeTypeSelect.getDocumentNodetypes()) {
                    ((UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(nodeTypeName)).setChecked(false);
                    selectedNodetypes.remove(nodeTypeName);
                }
            }
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchNodeTypeActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            UIFormStringInput uiInputNodeType = (UIFormStringInput)uiNodeTypeSelector.findComponentById("NodeTypeText");
            String nodeTypeName = (String)uiInputNodeType.getValue();
            if (nodeTypeName == null || nodeTypeName.length() == 0) {
                return;
            }
            nodeTypeName = nodeTypeName.contains("*") && !nodeTypeName.contains(".*") ? nodeTypeName.replace("*", ".*") : nodeTypeName;
            Pattern p = Pattern.compile(".*".concat(nodeTypeName.trim()).concat(".*"), 2);
            if (uiNodeTypeSelector.getLSTNodetype() == null) {
                uiNodeTypeSelector.setLSTNodetype(uiNodeTypeSelector.getAllNodeTypes());
            }
            ArrayList<NodeType> lstNodetype = new ArrayList<NodeType>();
            for (NodeType nodeType : uiNodeTypeSelector.getLSTNodetype()) {
                if (!p.matcher(nodeType.getName()).find()) continue;
                lstNodetype.add(nodeType);
            }
            uiNodeTypeSelector.init(1, uiNodeTypeSelector.getSelectedNodetypes(), lstNodetype);
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

