/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyWorkingArea;
import org.exoplatform.ecm.webui.tree.UINodeTree;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTree.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UITaxonomyTree
extends UIContainer {
    private Node currentNode_;
    private Node rootNode_ = null;
    private String rootPath_;

    public UITaxonomyTree() throws Exception {
        UINodeTree tree = (UINodeTree)this.addChild(UINodeTree.class, null, "UITaxonomyTree");
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
    }

    public void update() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        this.rootNode_ = uiManager.getRootNode();
        this.rootPath_ = this.rootNode_.getPath();
    }

    public Node getRootNode() throws Exception {
        return this.rootNode_;
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        Object children = null;
        UITaxonomyManager uiTaxonomyManager = (UITaxonomyManager)this.getParent();
        ArrayList<Node> taxonomyList = new ArrayList<Node>();
        if (this.rootNode_ == null) {
            this.update();
            this.currentNode_ = this.rootNode_;
            children = this.rootNode_.getNodes();
            this.changeNode(this.rootNode_);
        }
        UINodeTree tree = (UINodeTree)this.getChildById("UITaxonomyTree");
        Node nodeSelected = this.getSelectedNode();
        if (nodeSelected.getPath().equals(this.rootPath_) || this.rootNode_.getParent().getPath().equals(this.currentNode_.getPath())) {
            nodeSelected = this.rootNode_;
            children = nodeSelected.getNodes();
        }
        tree.setSelected((Object)nodeSelected);
        if (nodeSelected.getDepth() > 0) {
            tree.setParentSelected((Object)nodeSelected.getParent());
            sibbling = nodeSelected.getParent().getNodes();
            children = nodeSelected.getNodes();
        } else {
            tree.setParentSelected((Object)nodeSelected);
            sibbling = nodeSelected.getNodes();
        }
        ArrayList<Node> sibblingList = new ArrayList<Node>();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        if (nodeSelected.getPath().equals(uiTaxonomyManager.getTaxonomyNode().getPath())) {
            sibbling = nodeSelected.getNodes();
        }
        while (sibbling.hasNext()) {
            Node sibblingNode = (Node)sibbling.next();
            if (!PermissionUtil.canRead((Node)sibblingNode) || sibblingNode.isNodeType("exo:hiddenable")) continue;
            sibblingList.add(sibblingNode);
        }
        if (nodeSelected.getPath().equals(this.rootPath_) || this.rootNode_.getParent().getPath().equals(this.currentNode_.getPath())) {
            taxonomyList.add(uiTaxonomyManager.getTaxonomyNode());
            children = taxonomyList.iterator();
        }
        if (children != null) {
            while (children.hasNext()) {
                Node childrenNode = (Node)children.next();
                if (!PermissionUtil.canRead((Node)childrenNode) || childrenNode.isNodeType("exo:hiddenable")) continue;
                childrenList.add(childrenNode);
            }
        }
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            tree.setSibbling(childrenList);
        } else {
            tree.setSibbling(sibblingList);
        }
        tree.setChildren(childrenList);
    }

    public void renderChildren() throws Exception {
        this.buildTree();
        super.renderChildren();
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setNodeSelect(String path) throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        this.currentNode_ = uiManager.getNodeByPath(path);
        if (this.rootNode_.getParent().getPath().equals(path)) {
            this.currentNode_ = this.rootNode_;
        }
        uiManager.setSelectedPath(this.currentNode_.getPath());
        this.changeNode(this.currentNode_);
    }

    public void changeNode(Node nodeSelected) throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator nodeIter = nodeSelected.getNodes();
        ArrayList<Node> rootTaxonomyList = new ArrayList<Node>();
        UITaxonomyManager uiTaxonomyManager = (UITaxonomyManager)this.getParent();
        while (nodeIter.hasNext()) {
            nodes.add(nodeIter.nextNode());
        }
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            rootTaxonomyList.add(uiTaxonomyManager.getTaxonomyNode());
            nodes = rootTaxonomyList;
        }
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)uiManager.getChild(UITaxonomyWorkingArea.class);
        uiWorkingArea.setNodeList(nodes);
        uiWorkingArea.updateGrid();
    }

    public Node getSelectedNode() {
        if (this.currentNode_ == null) {
            return this.rootNode_;
        }
        return this.currentNode_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITaxonomyTree> {
        public void execute(Event<UITaxonomyTree> event) throws Exception {
            UITaxonomyTree uiTaxonomyTree = (UITaxonomyTree)((Object)event.getSource());
            String uri = event.getRequestContext().getRequestParameter("objectId");
            uiTaxonomyTree.setNodeSelect(uri);
            UITaxonomyManager uiTaxonomyManager = (UITaxonomyManager)uiTaxonomyTree.getParent();
            uiTaxonomyManager.onChange(uiTaxonomyTree.getSelectedNode());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManager);
        }
    }
}

