/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ks/social-integration/plugin/space/ForumUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class ForumUIActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(ForumUIActivity.class);

    public String getUriOfAuthor() {
        String userId = this.getActivity().getUserId();
        try {
            return "<a href='" + this.getUserProfileUri(userId) + "'>" + this.getUserFullName(userId) + "</a>";
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("can not get Url of user " + userId), (Throwable)e);
            }
            return "";
        }
    }

    private String getViewLink() {
        String link = "";
        link = this.getActivityParamValue("ActivityType").toLowerCase().indexOf("topic") >= 0 ? this.getActivityParamValue("TopicLink") : this.getActivityParamValue("PostLink") + "/" + this.getActivityParamValue("PostId");
        return link;
    }

    private String getReplyLink() {
        String link = this.getViewLink();
        if (!link.endsWith("/")) {
            link = link + "/";
        }
        link = link + "false";
        return link;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }
}

