/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.ws;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.ws.BanIP;
import org.exoplatform.forum.service.ws.BeanToJsons;
import org.exoplatform.forum.service.ws.MessageBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="ks/forum")
public class ForumWebservice
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    public static final String APP_TYPE = "forum".intern();
    private String strQuery;
    private List<BanIP> ipsToJson = new ArrayList<BanIP>();
    private static Log log = ExoLogger.getLogger(ForumWebservice.class);

    private BeanToJsons<MessageBean> getNewPosts(String userName, int maxcount) throws Exception {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        List<Post> list = forumService.getRecentPostsForUser(userName, maxcount);
        ArrayList<MessageBean> lastMessages = new ArrayList<MessageBean>();
        if (list != null) {
            for (Post post : list) {
                post.setLink(post.getLink() + "/" + post.getId());
                lastMessages.add(new MessageBean(post));
            }
        }
        return new BeanToJsons<MessageBean>(lastMessages);
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get user id", (Throwable)e);
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    @GET
    @Path(value="getmessage/{maxcount}")
    @Produces(value={"application/json"})
    public Response getMessage(@PathParam(value="maxcount") int maxcount, @Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            String userName = this.getUserId(sc, uriInfo);
            BeanToJsons<MessageBean> data = this.getNewPosts(userName, maxcount);
            return Response.ok(data, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get new post by user.");
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="getpublicmessage/{maxcount}")
    @Produces(value={"application/json"})
    public Response getPublicMessage(@PathParam(value="maxcount") int maxcount) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        BeanToJsons<MessageBean> data = this.getNewPosts(null, maxcount);
        return Response.ok(data, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="filter/{strIP}")
    @Produces(value={"application/json"})
    public Response filterIps(@PathParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getBanList();
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getBanList();
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="filterIpBanforum/{strForumId}/{strIP}")
    @Produces(value={"application/json"})
    public Response filterIpBanForum(@PathParam(value="strForumId") String forumId, @PathParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="filterTagNameForum/{userAndTopicId}/{strTagName}")
    @Produces(value={"application/json"})
    public Response filterTagNameForum(@PathParam(value="strTagName") String str, @PathParam(value="userAndTopicId") String userAndTopicId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals(" ")) {
            this.ipsToJson.clear();
        } else if (str.equals("onclickForm")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getTagNameInTopic(userAndTopicId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getAllTagName(str, userAndTopicId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="rss/{resourceid}")
    @Produces(value={"application/xml"})
    public Response viewrss(@PathParam(value="resourceid") String resourceid) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            InputStream is = forumService.createForumRss(resourceid, "http://www.exoplatform.com");
            return Response.ok((Object)is, (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.trace((Object)("\nView RSS fail: " + e.getMessage() + "\n" + e.getCause()));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="rss/user/{resourceid}")
    @Produces(value={"text/xml"})
    public Response userrss(@PathParam(value="resourceid") String resourceid) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            InputStream is = forumService.createUserRss(resourceid, "http://www.exoplatform.com");
            return Response.ok((Object)is, (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.trace((Object)"\nGet UserRSS fail: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

