/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.ConnectionFactory;

public class JDBCConnectionFactory
implements ConnectionFactory {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.NonManagedConnectionFactory");
    private static final boolean trace = LOG.isTraceEnabled();
    static final ThreadLocal<Connection> connection = new ThreadLocal();
    private DataSource dataSource;
    private String datasourceName;

    public void setConfig(AdjListJDBCCacheLoaderConfig config) {
        this.datasourceName = config.getDatasourceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws Exception {
        InitialContext ctx;
        block8: {
            ctx = null;
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.datasourceName);
            if (!trace) break block8;
            LOG.trace((Object)("Datasource lookup for " + this.datasourceName + " succeded: " + this.dataSource));
        }
        Object var4_2 = null;
        if (ctx == null) return;
        try {
            ctx.close();
            return;
        }
        catch (NamingException e2) {
            LOG.warn((Object)"Failed to close naming context.", (Throwable)e2);
        }
        return;
        {
            catch (NamingException e) {
                this.reportAndRethrowError("Failed to lookup datasource " + this.datasourceName, e);
                Object var4_3 = null;
                if (ctx == null) return;
                try {
                    ctx.close();
                    return;
                }
                catch (NamingException e2) {
                    LOG.warn((Object)"Failed to close naming context.", (Throwable)e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e2) {
                LOG.warn((Object)"Failed to close naming context.", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public void prepare(Object tx) {
        Connection con = this.getConnection();
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (Exception e) {
            this.reportAndRethrowError("Failed to set auto-commit", e);
        }
        connection.set(con);
        if (trace) {
            LOG.trace((Object)("opened tx connection: tx=" + tx + ", con=" + con));
        }
    }

    public Connection getConnection() {
        Connection con = connection.get();
        if (con == null) {
            try {
                con = this.checkoutConnection();
            }
            catch (SQLException e) {
                this.reportAndRethrowError("Failed to get connection for datasource=" + this.datasourceName, e);
            }
        }
        if (trace) {
            LOG.trace((Object)("using connection: " + con));
        }
        return con;
    }

    public Connection checkoutConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Object tx) {
        Connection con = connection.get();
        if (con == null) {
            throw new IllegalStateException("Failed to commit: thread is not associated with the connection!");
        }
        try {
            block5: {
                try {
                    con.commit();
                    if (!trace) break block5;
                    LOG.trace((Object)("committed tx=" + tx + ", con=" + con));
                }
                catch (SQLException e) {
                    this.reportAndRethrowError("Failed to commit", e);
                    Object var5_4 = null;
                    this.closeTxConnection(con);
                }
            }
            Object var5_3 = null;
            this.closeTxConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeTxConnection(con);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Object tx) {
        Connection con = connection.get();
        try {
            block4: {
                try {
                    con.rollback();
                    if (!trace) break block4;
                    LOG.trace((Object)("rolledback tx=" + tx + ", con=" + con));
                }
                catch (SQLException e) {
                    this.reportAndRethrowError("Failed to rollback", e);
                    Object var5_4 = null;
                    this.closeTxConnection(con);
                }
            }
            Object var5_3 = null;
            this.closeTxConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeTxConnection(con);
            throw throwable;
        }
    }

    public void close(Connection con) {
        if (con != null && con != connection.get()) {
            try {
                con.close();
                if (trace) {
                    LOG.trace((Object)("closed non tx connection: " + con));
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)("Failed to close connection " + con), (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    private void closeTxConnection(Connection con) {
        this.safeClose(con);
        connection.set(null);
    }

    private void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }

    private void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        LOG.error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }
}

