/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.activity.model.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityManager {
    private static final Log LOG = ExoLogger.getLogger(ActivityManager.class);
    private ActivityStorage storage;
    private SortedSet<ActivityProcessor> processors;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ExoCache<String, Activity> activityCache;
    private ExoCache<String, Map<Segment, List<Activity>>> activityListCache;
    private ExoCache<String, List<Activity>> commentsCache;

    public ActivityManager(ActivityStorage activityStorage, IdentityManager identityManager, CacheService cacheService) {
        this.storage = activityStorage;
        this.processors = new TreeSet<ActivityProcessor>(ActivityManager.processorComparator());
        this.identityManager = identityManager;
        this.activityCache = cacheService.getCacheInstance(this.getClass().getName() + "activityCache");
        this.activityListCache = cacheService.getCacheInstance(this.getClass().getName() + "activityListCache");
        this.commentsCache = cacheService.getCacheInstance(this.getClass().getName() + "commentsCache");
    }

    public Activity saveActivity(Identity owner, Activity activity) {
        Validate.notNull((Object)owner, (String)"owner must not be null.");
        Validate.notNull((Object)owner.getId(), (String)"owner.getId() must not be null");
        long now = System.currentTimeMillis();
        if (activity.getId() == null) {
            activity.setPostedTime(now);
        }
        activity.setUpdatedTimestamp(now);
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        activity = this.storage.saveActivity(owner, activity);
        this.activityListCache.remove((Serializable)((Object)owner.getId()));
        return activity;
    }

    public Activity getActivity(String activityId) {
        Activity cachedActivity = (Activity)this.activityCache.get((Serializable)((Object)activityId));
        if (cachedActivity == null && (cachedActivity = this.storage.getActivity(activityId)) != null) {
            this.processActivitiy(cachedActivity);
            this.activityCache.put((Serializable)((Object)activityId), (Object)cachedActivity);
        }
        return cachedActivity;
    }

    public void deleteActivity(String activityId) {
        Activity activity = this.storage.getActivity(activityId);
        if (activity != null) {
            Identity streamOwner = this.identityManager.getIdentity(activity.getUserId(), false);
            this.storage.deleteActivity(activityId);
            try {
                this.activityCache.remove((Serializable)((Object)activityId));
                this.activityListCache.remove((Serializable)((Object)streamOwner.getId()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void deleteActivity(Activity activity) {
        Validate.notNull((Object)"activity.getId() must not be null", (String)activity.getId());
        this.deleteActivity(activity.getId());
    }

    public void clearCache() {
        this.activityCache.clearCache();
        this.activityListCache.clearCache();
        this.commentsCache.clearCache();
    }

    public void deleteComment(String activityId, String commentId) {
        this.storage.deleteComment(activityId, commentId);
        this.activityCache.remove((Serializable)((Object)activityId));
        this.commentsCache.remove((Serializable)((Object)activityId));
    }

    public List<Activity> getActivities(Identity identity) {
        return this.storage.getActivities(identity, 0L, 20L);
    }

    public List<Activity> getActivities(Identity identity, long start, long limit) {
        Segment segment = new Segment(start, limit);
        HashMap<Segment, List<Activity>> segments = (HashMap<Segment, List<Activity>>)this.activityListCache.get((Serializable)((Object)identity.getId()));
        if (segments == null || segments.get(segment) == null) {
            segments = new HashMap<Segment, List<Activity>>();
            List<Activity> activityList = this.storage.getActivities(identity, start, limit);
            for (Activity activity : activityList) {
                this.processActivitiy(activity);
            }
            segments.put(segment, activityList);
            this.activityListCache.put((Serializable)((Object)identity.getId()), segments);
        }
        return (List)segments.get(segment);
    }

    public List<Activity> getActivitiesOfConnections(Identity ownerIdentity) {
        return this.getActivitiesOfConnections(ownerIdentity, 0, 30);
    }

    public List<Activity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        List<Identity> connectionList = null;
        try {
            connectionList = this.identityManager.getConnections(ownerIdentity);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to getActivitiesOfConnections of: " + ownerIdentity.getRemoteId()), (Throwable)e);
        }
        return this.storage.getActivitiesOfConnections(connectionList, offset, limit);
    }

    public List<Activity> getActivitiesOfUserSpaces(Identity ownerIdentity) {
        this.spaceService = this.getSpaceService();
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        List<Space> accessibleSpaceList = null;
        try {
            accessibleSpaceList = this.spaceService.getAccessibleSpaces(ownerIdentity.getRemoteId());
        }
        catch (SpaceException e1) {
            LOG.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        for (Space space : accessibleSpaceList) {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getId());
            try {
                activityList.addAll(this.getActivities(spaceIdentity));
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        Collections.sort(activityList, Util.activityComparator());
        return activityList;
    }

    public List<Activity> getActivityFeed(Identity identity) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        activityList.addAll(this.getActivitiesOfConnections(identity));
        activityList.addAll(this.getActivitiesOfUserSpaces(identity));
        activityList.addAll(this.getActivities(identity));
        Collections.sort(activityList, Util.activityComparator());
        return activityList;
    }

    public Activity saveActivity(Activity activity) {
        Validate.notNull((Object)activity.getUserId(), (String)"activity.getUserId() must not be null.");
        Identity owner = this.identityManager.getIdentity(activity.getUserId());
        return this.saveActivity(owner, activity);
    }

    public void saveComment(Activity activity, Activity comment) {
        activity.setTitle(null);
        activity.setBody(null);
        this.storage.saveComment(activity, comment);
        this.activityCache.remove((Serializable)((Object)activity.getId()));
        this.commentsCache.remove((Serializable)((Object)activity.getId()));
    }

    public void saveLike(Activity activity, Identity identity) {
        activity.setTitle(null);
        activity.setBody(null);
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        activity.setLikeIdentityIds((String[])identityIds);
        this.saveActivity(activity);
        this.activityCache.remove((Serializable)((Object)activity.getId()));
    }

    public void removeLike(Activity activity, Identity identity) {
        activity.setTitle(null);
        activity.setBody(null);
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.saveActivity(activity);
            this.activityCache.remove((Serializable)((Object)activity.getId()));
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    public List<Activity> getComments(Activity activity) {
        String activityId = activity.getId();
        ArrayList<Activity> cachedComments = (ArrayList<Activity>)this.commentsCache.get((Serializable)((Object)activityId));
        if (cachedComments == null) {
            activity = this.getActivity(activityId);
            cachedComments = new ArrayList<Activity>();
            String rawCommentIds = activity.getReplyToId();
            if (rawCommentIds != null) {
                Object[] commentIds = rawCommentIds.split(",");
                for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                    Activity comment = this.storage.getActivity((String)commentId);
                    this.processActivitiy(comment);
                    cachedComments.add(comment);
                }
                if (cachedComments.size() > 0) {
                    this.commentsCache.put((Serializable)((Object)activityId), cachedComments);
                }
            }
        }
        return cachedComments;
    }

    public Activity recordActivity(Identity owner, String type, String title, String body) {
        String userId = owner.getId();
        Activity activity = new Activity(userId, type, title, body);
        return this.saveActivity(owner, activity);
    }

    public Activity recordActivity(Identity owner, Activity activity) throws Exception {
        return this.saveActivity(owner, activity);
    }

    public void addProcessor(ActivityProcessor processor) {
        this.processors.add(processor);
        LOG.info((Object)("added activity processor " + processor.getClass()));
    }

    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor(plugin);
    }

    private static Comparator<ActivityProcessor> processorComparator() {
        return new Comparator<ActivityProcessor>(){

            @Override
            public int compare(ActivityProcessor p1, ActivityProcessor p2) {
                if (p1 == null || p1 == null) {
                    throw new IllegalArgumentException("Cannot compare null ActivityProcessor");
                }
                return p1.getPriority() - p2.getPriority();
            }
        };
    }

    public int getActivitiesCount(Identity owner) {
        return this.storage.getActivitiesCount(owner);
    }

    public void processActivitiy(Activity activity) {
        Iterator it = this.processors.iterator();
        while (it.hasNext()) {
            try {
                ((ActivityProcessor)it.next()).processActivity(activity);
            }
            catch (Exception e) {
                LOG.warn((Object)("activity processing failed " + e.getMessage()));
            }
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private class Segment {
        private long start;
        private long limit;

        public Segment(long start, long limit) {
            this.start = start;
            this.limit = limit;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.limit != other.limit) {
                return false;
            }
            return this.start == other.start;
        }

        private ActivityManager getOuterType() {
            return ActivityManager.this;
        }
    }
}

