/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship.model;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Relationship {
    private String id;
    private List<Property> properties;
    private Identity sender;
    private Identity receiver;
    private Type status = Type.PENDING;

    public Relationship(Identity sender, Identity receiver) {
        this(sender, receiver, new ArrayList<Property>());
    }

    public Relationship(Identity sender, Identity receiver, List<Property> properties) {
        this.sender = sender;
        this.receiver = receiver;
        this.properties = properties;
    }

    public Relationship(String uuid) {
        this.id = uuid;
        this.properties = new ArrayList<Property>();
    }

    public Identity getSender() {
        return this.sender;
    }

    public Identity getReceiver() {
        return this.receiver;
    }

    public void setSender(Identity sender) {
        this.sender = sender;
    }

    public void setReceiver(Identity receiver) {
        this.receiver = receiver;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Type getStatus() {
        return this.status;
    }

    public void setStatus(Type status) {
        this.status = status;
    }

    public Identity getPartner(Identity identity) {
        if (identity.getId().equals(this.sender.getId())) {
            return this.receiver;
        }
        if (identity.getId().equals(this.receiver.getId())) {
            return this.sender;
        }
        return null;
    }

    public List<Property> getProperties(Type status) {
        ArrayList<Property> pendingProps = new ArrayList<Property>();
        for (Property prop : this.properties) {
            if (prop.getStatus() != status) continue;
            pendingProps.add(prop);
        }
        return pendingProps;
    }

    public String toString() {
        return this.sender + "--[" + (Object)((Object)this.status) + "]--" + this.receiver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PENDING,
        CONFIRM,
        IGNORE,
        ALIEN,
        REQUIRE_VALIDATION,
        SELF,
        SPACE_MEMBER;

    }
}

