/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.apache.commons.lang.Validate;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;

public class LinkProvider {
    private IdentityManager identityManager;
    private static Log LOG = ExoLogger.getLogger(LinkProvider.class);
    public static String DEFAULT_PORTAL_OWNER = "classic";

    public LinkProvider(InitParams params) {
        if (params.getValueParam("predefinedOwner") != null) {
            DEFAULT_PORTAL_OWNER = params.getValueParam("predefinedOwner").getValue();
        }
    }

    public LinkProvider(InitParams params, IdentityManager identityManager) {
        this.identityManager = identityManager;
        this.init(params);
    }

    private void init(InitParams params) {
        if (params.getValueParam("predefinedOwner") != null) {
            DEFAULT_PORTAL_OWNER = params.getValueParam("predefinedOwner").getValue();
        }
    }

    public String getProfileUri(String username) {
        return this.getProfileUri(username, null);
    }

    public String getProfileUri(String username, String portalOwner) {
        String url = null;
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            portalOwner = DEFAULT_PORTAL_OWNER;
        }
        try {
            url = LinkProvider.getBaseUri(portalOwner) + "/profile/" + username;
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to substitute username for " + username + ": " + e.getMessage()));
        }
        return url;
    }

    public String getProfileLink(String username) {
        return this.getProfileLink(username, null);
    }

    public String getProfileLink(String username, String portalOwner) {
        String link = null;
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            portalOwner = DEFAULT_PORTAL_OWNER;
        }
        try {
            Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", username, true);
            Validate.notNull((Object)identity, (String)"Identity must not be null.");
            String url = LinkProvider.getBaseUri(portalOwner) + "/profile/" + identity.getRemoteId();
            link = "<a href=\"" + url + "\" target=\"_parent\">" + identity.getProfile().getFullName() + "</a>";
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to substitute username for " + username + ": " + e.getMessage()));
        }
        return link;
    }

    public String getAbsoluteProfileUrl(String userName, String portalName, String portalOwner, String host) {
        String url = null;
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            portalOwner = DEFAULT_PORTAL_OWNER;
        }
        try {
            Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", userName, true);
            Validate.notNull((Object)identity, (String)"Identity must not be null.");
            url = host + LinkProvider.getBaseUri(portalOwner) + "/profile/" + identity.getRemoteId();
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to substitute username for " + userName + ": " + e.getMessage()));
        }
        return url;
    }

    public static String buildAvatarUrl(AvatarAttachment avatarAttachment) {
        String avatarUrl = null;
        try {
            String repository = ((RepositoryService)PortalContainer.getComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
            avatarUrl = "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + repository + "/" + avatarAttachment.getWorkspace() + avatarAttachment.getDataPath() + "/?rnd=" + avatarAttachment.getLastModified();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to build avatar url from avatar attachment for: " + e.getMessage()));
        }
        return avatarUrl;
    }

    private static String getBaseUri(String portalOwner) {
        String portalName = PortalContainer.getCurrentPortalContainerName();
        return "/" + portalName + "/private/" + LinkProvider.getPortalOwner(portalOwner);
    }

    private static String getPortalOwner(String portalOwner) {
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            try {
                return Util.getPortalRequestContext().getPortalOwner();
            }
            catch (Exception e) {
                return DEFAULT_PORTAL_OWNER;
            }
        }
        return portalOwner;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }
}

