/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UIJCRAdvancedSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISavedQuery.gtmpl", events={@EventConfig(listeners={ExecuteActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UISavedQuery.msg.confirm-delete-query"), @EventConfig(listeners={EditActionListener.class})})
public class UISavedQuery
extends UIContainer
implements UIPopupComponent {
    public static final String EDIT_FORM = "EditSavedQueryForm";
    private UIPageIterator uiPageIterator_;
    private List<Node> sharedQueries_ = new ArrayList<Node>();
    private List<Query> privateQueries = new ArrayList<Query>();
    private boolean isQuickSearch_ = false;
    private String repositoryName_;

    public UISavedQuery() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "SavedQueryIterator");
    }

    public void updateGrid(int currentPage) throws Exception {
        ObjectPageList pageList = new ObjectPageList(this.queryList(), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (currentPage > this.uiPageIterator_.getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public List<Object> queryList() throws Exception {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (this.hasSharedQueries()) {
            for (Node node : this.getSharedQueries()) {
                objectList.add(node);
            }
        }
        if (this.hasQueries()) {
            for (Query query : this.getQueries()) {
                objectList.add(query);
            }
        }
        return objectList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getQueryList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void initPopupEditForm(Query query) throws Exception {
        this.removeChildById(EDIT_FORM);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, EDIT_FORM);
        uiPopup.setWindowSize(500, 0);
        UIJCRAdvancedSearch uiJAdvancedSearch = (UIJCRAdvancedSearch)this.createUIComponent(UIJCRAdvancedSearch.class, null, "EditQueryForm");
        uiJAdvancedSearch.setActions(new String[]{"Save", "Cancel"});
        uiPopup.setUIComponent((UIComponent)uiJAdvancedSearch);
        uiPopup.setRendered(true);
        uiJAdvancedSearch.setIsEdit(true);
        uiJAdvancedSearch.setQuery(query);
        uiJAdvancedSearch.update(query);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public boolean hasQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        try {
            this.privateQueries = queryService.getQueries(this.getCurrentUserId(), this.repositoryName_, SessionProviderFactory.createSessionProvider());
            return !this.privateQueries.isEmpty();
        }
        catch (AccessDeniedException ace) {
            return this.privateQueries.isEmpty();
        }
    }

    public List<Query> getQueries() throws Exception {
        return this.privateQueries;
    }

    public String getCurrentUserId() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public boolean hasSharedQueries() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String userId = pcontext.getRemoteUser();
        SessionProvider provider = SessionProviderFactory.createSystemProvider();
        this.sharedQueries_ = queryService.getSharedQueries(userId, this.repositoryName_, provider);
        return !this.sharedQueries_.isEmpty();
    }

    public List<Node> getSharedQueries() {
        return this.sharedQueries_;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setIsQuickSearch(boolean isQuickSearch) {
        this.isQuickSearch_ = isQuickSearch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UISavedQuery> {
        public void execute(Event<UISavedQuery> event) throws Exception {
            UISavedQuery uiQuery = (UISavedQuery)((Object)event.getSource());
            String userName = Util.getPortalRequestContext().getRemoteUser();
            QueryService queryService = (QueryService)uiQuery.getApplicationComponent(QueryService.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            queryService.removeQuery(path, userName, uiQuery.repositoryName_);
            uiQuery.updateGrid(uiQuery.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQuery);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UISavedQuery> {
        public void execute(Event<UISavedQuery> event) throws Exception {
            UISavedQuery uiQuery = (UISavedQuery)((Object)event.getSource());
            String userName = Util.getPortalRequestContext().getRemoteUser();
            QueryService queryService = (QueryService)uiQuery.getApplicationComponent(QueryService.class);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            Query query = queryService.getQueryByPath(queryPath, userName, uiQuery.repositoryName_, SessionProviderFactory.createSystemProvider());
            uiQuery.initPopupEditForm(query);
            if (!uiQuery.isQuickSearch_) {
                UIECMSearch uiECSearch = (UIECMSearch)uiQuery.getParent();
                uiECSearch.setRenderedChild(UISavedQuery.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiECSearch);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiQuery.getParent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecuteActionListener
    extends EventListener<UISavedQuery> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UISavedQuery> event) throws Exception {
            UISavedQuery uiQuery = (UISavedQuery)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiQuery.getAncestorOfType(UIJCRExplorer.class);
            String wsName = ((UIJCRExplorer)uiQuery.getAncestorOfType(UIJCRExplorer.class)).getCurrentWorkspace();
            UIApplication uiApp = (UIApplication)uiQuery.getAncestorOfType(UIApplication.class);
            QueryService queryService = (QueryService)uiQuery.getApplicationComponent(QueryService.class);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            UIComponent uiSearch = null;
            UISearchResult uiSearchResult = null;
            if (uiQuery.isQuickSearch_) {
                uiSearch = ((UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class)).getChild(UIDocumentWorkspace.class);
                uiSearchResult = (UISearchResult)((UIDocumentWorkspace)uiSearch).getChild(UISearchResult.class);
            } else {
                uiSearch = uiQuery.getParent();
                ((UIECMSearch)uiSearch).setRenderedChild(UISearchResult.class);
                uiSearchResult = (UISearchResult)((UIECMSearch)uiSearch).getChild(UISearchResult.class);
            }
            QueryResult queryResult = null;
            try {
                queryResult = queryService.execute(queryPath, wsName, uiQuery.repositoryName_, SessionProviderFactory.createSystemProvider(), uiQuery.getCurrentUserId());
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.query-invalid", null, 1));
                if (!uiQuery.isQuickSearch_) {
                    ((UIECMSearch)uiSearch).setRenderedChild(UISavedQuery.class);
                }
                return;
            }
            finally {
                if (queryResult == null || queryResult.getNodes().getSize() == 0L) {
                    uiApp.addMessage(new ApplicationMessage("UISavedQuery.msg.not-result-found", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    if (!uiQuery.isQuickSearch_) {
                        ((UIECMSearch)uiSearch).setRenderedChild(UISavedQuery.class);
                    }
                    return;
                }
                uiSearchResult.clearAll();
                uiSearchResult.setQueryResults(queryResult);
            }
            if (uiQuery.isQuickSearch_) {
                ((UIDocumentWorkspace)uiSearch).setRenderedChild(UISearchResult.class);
                UIPopupContainer uiPopup = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                uiPopup.deActivate();
            }
        }
    }
}

