/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.util.List;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.contact.service.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRPageList {
    private long pageSize_;
    protected long available_ = 0L;
    protected long availablePage_ = 1L;
    protected long currentPage_ = 1L;
    protected List<Contact> currentListPage_;

    public JCRPageList(long pageSize) {
        this.pageSize_ = pageSize;
    }

    public long getPageSize() {
        return this.pageSize_;
    }

    public void setPageSize(long pageSize) {
        this.pageSize_ = pageSize;
        this.setAvailablePage(this.available_);
    }

    public void setCurrentPage(long page) {
        this.currentPage_ = page;
    }

    public long getCurrentPage() {
        return this.currentPage_;
    }

    public long getAvailable() {
        return this.available_;
    }

    public long getAvailablePage() {
        return this.availablePage_;
    }

    public List<Contact> currentPage(String username) throws Exception {
        if (this.currentListPage_ == null) {
            this.populateCurrentPage(this.currentPage_, username);
        }
        return this.currentListPage_;
    }

    public void setContact(List<Contact> contacts, boolean isUpdate) throws Exception {
        if (this.currentListPage_ == null) {
            return;
        }
        block0: for (Contact ct : contacts) {
            for (int i = 0; i < this.currentListPage_.size(); ++i) {
                if (!this.currentListPage_.get(i).getId().endsWith(ct.getId())) continue;
                if (isUpdate) {
                    this.currentListPage_.set(i, ct);
                    continue block0;
                }
                this.currentListPage_.remove(i);
                continue block0;
            }
        }
    }

    protected abstract void populateCurrentPage(long var1, String var3) throws Exception;

    public List<Contact> getPage(long page, String username) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPage(page, username);
        return this.currentListPage_;
    }

    public abstract List<Contact> getAll() throws Exception;

    public abstract void setList(List<Contact> var1);

    protected void checkAndSetPage(long page) throws Exception {
        if (page < 1L || page > this.availablePage_) {
            Object[] args = new Object[]{Long.toString(page), Long.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.currentPage_ = page;
    }

    protected void setAvailablePage(long available) {
        this.available_ = available;
        if (available == 0L) {
            this.availablePage_ = 1L;
            this.currentPage_ = 1L;
        } else {
            long pages = available / this.pageSize_;
            if (available % this.pageSize_ > 0L) {
                ++pages;
            }
            this.availablePage_ = pages;
        }
    }
}

