/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.text.unicode;

import org.exoplatform.services.text.unicode.NormalizerBuilder;
import org.exoplatform.services.text.unicode.NormalizerData;
import org.exoplatform.services.text.unicode.UTF16;

public class Normalizer {
    static final byte COMPATIBILITY_MASK = 1;
    static final byte COMPOSITION_MASK = 2;
    public static final byte D = 0;
    public static final byte C = 2;
    public static final byte KD = 1;
    public static final byte KC = 3;
    private static NormalizerData data = null;
    private byte form;

    public Normalizer() {
        this(2);
    }

    public Normalizer(byte form) {
        this.form = form;
        if (data == null) {
            data = NormalizerBuilder.getInstance().build();
        }
    }

    public StringBuilder normalize(String source, StringBuilder target) {
        if (source.length() == 0) {
            return target;
        }
        this.internalDecompose(source, target);
        if ((this.form & 2) == 0) {
            return target;
        }
        this.internalCompose(target);
        return target;
    }

    public String normalize(String source) {
        return this.normalize(source, new StringBuilder()).toString();
    }

    public char[] normalize(char[] chars) {
        StringBuilder builder = new StringBuilder();
        this.normalize(new String(chars), builder);
        return builder.toString().toCharArray();
    }

    private void internalDecompose(String source, StringBuilder target) {
        int ch32;
        StringBuilder buffer = new StringBuilder();
        boolean canonical = (this.form & 1) == 0;
        for (int i = 0; i < source.length(); i += UTF16.getInstance().getCharCount(ch32)) {
            int ch;
            buffer.setLength(0);
            ch32 = UTF16.getInstance().charAt(source, i);
            data.getRecursiveDecomposition(canonical, (char)ch32, buffer);
            for (int j = 0; j < buffer.length(); j += UTF16.getInstance().getCharCount(ch)) {
                int k;
                ch = UTF16.getInstance().charAt(buffer, j);
                int chClass = data.getCanonicalClass((char)ch);
                if (chClass != 0) {
                    int ch2;
                    for (k = target.length(); k > 0 && data.getCanonicalClass((char)(ch2 = UTF16.getInstance().charAt(target, k - 1))) > chClass; k -= UTF16.getInstance().getCharCount(ch2)) {
                    }
                }
                target.insert(k, UTF16.getInstance().valueOf(ch));
            }
        }
    }

    private void internalCompose(StringBuilder target) {
        int ch;
        int starterPos = 0;
        int starterCh = UTF16.getInstance().charAt(target, 0);
        int compPos = UTF16.getInstance().getCharCount(starterCh);
        int lastClass = data.getCanonicalClass((char)starterCh);
        if (lastClass != 0) {
            lastClass = 256;
        }
        int oldLen = target.length();
        for (int decompPos = compPos; decompPos < target.length(); decompPos += UTF16.getInstance().getCharCount(ch)) {
            ch = UTF16.getInstance().charAt(target, decompPos);
            int chClass = data.getCanonicalClass((char)ch);
            char composite = data.getPairwiseComposition((char)starterCh, (char)ch);
            if (composite != '\uffff' && (lastClass < chClass || lastClass == 0)) {
                UTF16.getInstance().setCharAt(target, starterPos, composite);
                starterCh = composite;
                continue;
            }
            if (chClass == 0) {
                starterPos = compPos;
                starterCh = ch;
            }
            lastClass = chClass;
            UTF16.getInstance().setCharAt(target, compPos, ch);
            if (target.length() != oldLen) {
                decompPos += target.length() - oldLen;
                oldLen = target.length();
            }
            compPos += UTF16.getInstance().getCharCount(ch);
        }
        target.setLength(compPos);
    }
}

