/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.orbportability.ORBInfo;
import com.arjuna.orbportability.common.opPropertyManager;

public class RecoveryInit {
    private static boolean _initialised = false;
    private static boolean _isNormalProcess = true;
    private static final String eventHandlerPropertyPrefix = "com.arjuna.orbportability.eventHandler";

    public RecoveryInit() {
        if (!_initialised) {
            _initialised = true;
            String eventHandlerPropertyName = "com.arjuna.orbportability.eventHandler_Recovery";
            String eventHandlerPropertyValue = "com.arjuna.ats.internal.jts.recovery.contact.RecoveryContactWriter";
            Object recoveryCoordinatorInitialiser = null;
            String InitClassName = null;
            if (_isNormalProcess) {
                try {
                    int orbType = ORBInfo.getOrbEnumValue();
                    switch (orbType) {
                        case 0: {
                            InitClassName = "com.arjuna.ats.internal.jts.orbspecific.orbix2000.recoverycoordinators.Orbix2kRecoveryInit";
                            recoveryCoordinatorInitialiser = Thread.currentThread().getContextClassLoader().loadClass(InitClassName).newInstance();
                            break;
                        }
                        case 4: {
                            InitClassName = "com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRecoveryInit";
                            recoveryCoordinatorInitialiser = Thread.currentThread().getContextClassLoader().loadClass(InitClassName).newInstance();
                            break;
                        }
                        default: {
                            if (!jtsLogger.loggerI18N.isWarnEnabled()) break;
                            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.recoveryinit_1");
                        }
                    }
                    opPropertyManager.propertyManager.setProperty(eventHandlerPropertyName, eventHandlerPropertyValue);
                }
                catch (Exception e) {
                    jtsLogger.loggerI18N.fatal("com.arjuna.ats.internal.jts.recovery.RecoveryInit_4", new Object[]{e});
                    throw new FatalError();
                }
                if (jtsLogger.loggerI18N.isDebugEnabled()) {
                    jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.RecoveryInit_1");
                    jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.RecoveryInit_2", new Object[]{eventHandlerPropertyName, eventHandlerPropertyValue});
                }
            }
        }
    }

    public static void isNotANormalProcess() {
        _isNormalProcess = false;
    }

    public static boolean isNormalProcess() {
        return _isNormalProcess;
    }
}

