/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import java.text.SimpleDateFormat;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FCKFileHandler {
    private TemplateService templateService;
    private static final String[] IMAGE_MIMETYPE = new String[]{"image/gif", "image/jpeg", "image/bmp", "image/png", "image/tiff"};

    public FCKFileHandler(ExoContainer container) {
        this.templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
    }

    public String getFileType(Node node, String resourceType) throws Exception {
        if (FCKUtils.DOCUMENT_TYPE.equalsIgnoreCase(resourceType)) {
            return this.getDocumentType(node);
        }
        if (FCKUtils.IMAGE_TYPE.equalsIgnoreCase(resourceType)) {
            return this.getImageType(node);
        }
        if (FCKUtils.FLASH_TYPE.equalsIgnoreCase(resourceType)) {
            return this.getFlashType(node);
        }
        if (FCKUtils.LINK_TYPE.equalsIgnoreCase(resourceType)) {
            return this.getLinkType(node);
        }
        return null;
    }

    protected String getFileURL(Node file) throws Exception {
        return FCKUtils.createWebdavURL(file);
    }

    public Element createFileElement(Document document, Node child, String fileType) throws Exception {
        Element file = document.createElement("File");
        file.setAttribute("name", child.getName());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        file.setAttribute("dateCreated", formatter.format(child.getProperty("exo:dateCreated").getDate().getTime()));
        file.setAttribute("dateModified", formatter.format(child.getProperty("exo:dateModified").getDate().getTime()));
        file.setAttribute("creator", child.getProperty("exo:owner").getString());
        file.setAttribute("fileType", fileType);
        file.setAttribute("url", this.getFileURL(child));
        if (child.isNodeType(FCKUtils.NT_FILE)) {
            long size = child.getNode("jcr:content").getProperty("jcr:data").getLength();
            file.setAttribute("size", "" + size / 1000L);
        } else {
            file.setAttribute("size", "");
        }
        return file;
    }

    protected String getDocumentType(Node node) throws Exception {
        if (node.isNodeType("exo:presentationable")) {
            return node.getProperty("exo:presentationType").getString();
        }
        String primaryType = node.getPrimaryNodeType().getName();
        if (this.templateService.getDocumentTemplates().contains(primaryType)) {
            return primaryType;
        }
        return null;
    }

    protected String getImageType(Node node) throws Exception {
        if (node.isNodeType("nt:file")) {
            String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            for (String s : IMAGE_MIMETYPE) {
                if (!s.equals(mimeType)) continue;
                return node.getPrimaryNodeType().getName();
            }
        }
        return null;
    }

    protected String getFlashType(Node node) throws Exception {
        return null;
    }

    protected String getLinkType(Node node) throws Exception {
        return "exo:link";
    }
}

