/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.feedmash;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.extras.feedmash.Application;
import org.exoplatform.social.extras.feedmash.ApplicationsIdentityProvider;
import org.exoplatform.social.extras.feedmash.MashupStateHolder;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeedmashJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(AbstractFeedmashJob.class);
    protected static final String LAST_CHECKED = "lastChecked";
    protected String targetActivityStream;
    protected String portalContainer;
    protected String feedUrl;
    protected Integer rampup = 5;
    protected String pluginName;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            this.init(dataMap);
            if (this.severIsStarting(dataMap)) {
                return;
            }
            this.beforeJobExecute(dataMap);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(new URL(this.feedUrl)));
            List entries = feed.getEntries();
            for (SyndEntryImpl entry : entries) {
                if (!this.accept(entry)) continue;
                this.handle(entry);
            }
            this.saveState(LAST_CHECKED, new Date());
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    protected abstract void handle(SyndEntryImpl var1);

    protected abstract boolean accept(SyndEntryImpl var1);

    public void beforeJobExecute(JobDataMap dataMap) {
    }

    protected Object getState(String key) {
        String uniqueKey = this.getStateKey(key);
        return this.getExoComponent(MashupStateHolder.class).getState(uniqueKey);
    }

    protected void saveState(String key, Object state) {
        String uniqueKey = this.getStateKey(key);
        this.getExoComponent(MashupStateHolder.class).saveState(uniqueKey, state);
    }

    protected String getStateKey(String key) {
        return this.pluginName + "." + key;
    }

    protected boolean alreadyChecked(Date date) {
        Date lastChecked = (Date)this.getState(LAST_CHECKED);
        if (lastChecked == null) {
            return false;
        }
        return date.before(lastChecked);
    }

    protected <T> T getExoComponent(Class<T> type) {
        ExoContainer container = ExoContainerContext.getContainerByName((String)this.portalContainer);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        return (T)container.getComponentInstanceOfType(type);
    }

    protected void publishActivity(String message, Identity from, Identity to) throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(message);
        activity.setAppId("feedmash:" + this.getClass());
        activity.setUserId(from.getId());
        ActivityManager activityManager = this.getExoComponent(ActivityManager.class);
        activityManager.saveActivity(to, (ExoSocialActivity)activity);
    }

    protected Identity getIdentity(String targetUser) {
        Identity identity = null;
        try {
            IdentityManager identityManager = this.getExoComponent(IdentityManager.class);
            identity = identityManager.getIdentity(targetUser);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not find identity for " + targetUser + ": " + e.getMessage()));
        }
        return identity;
    }

    protected String getStringParam(JobDataMap dataMap, String name, String defaultValue) {
        String value = dataMap.getString(name);
        return value == null ? defaultValue : value;
    }

    protected Identity getAppIdentity(Application app) throws Exception {
        IdentityManager identityManager = this.getExoComponent(IdentityManager.class);
        ApplicationsIdentityProvider appIdentityProvider = new ApplicationsIdentityProvider();
        appIdentityProvider.addApplication(app);
        identityManager.addIdentityProvider((IdentityProvider)appIdentityProvider);
        Identity identity = identityManager.getOrCreateIdentity("apps", app.getId());
        return identity;
    }

    private void init(JobDataMap dataMap) {
        this.pluginName = dataMap.getString("pluginName");
        this.targetActivityStream = dataMap.getString("targetActivityStream");
        this.portalContainer = dataMap.getString("portalContainer");
        this.feedUrl = dataMap.getString("feedURL");
    }

    private boolean severIsStarting(JobDataMap dataMap) {
        this.rampup = (Integer)dataMap.get((Object)"rampup");
        if (this.rampup == null) {
            this.rampup = 2;
        }
        if (this.rampup > 1) {
            this.rampup = this.rampup - 1;
            dataMap.put((Object)"rampup", (Object)this.rampup);
            LOG.debug((Object)("waiting #" + this.rampup));
            return true;
        }
        return false;
    }
}

